/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.testing.database;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.hibernate.build.gradle.testing.database.AbstractDatabaseProfileImpl;

public class MatrixDotGradleProfile
extends AbstractDatabaseProfileImpl {
    private static final String MATRIX_NODE_CONVENTION_KEY = "matrixNode";
    private final Configuration jdbcDependencies = this.prepareConfiguration(this.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MatrixDotGradleProfile(File matrixDotGradleFile, Project project) {
        super(matrixDotGradleFile.getParentFile(), project);
        ConventionImpl convention = new ConventionImpl(this.jdbcDependencies, project);
        project.getConvention().getPlugins().put(MATRIX_NODE_CONVENTION_KEY, convention);
        try {
            project.apply(Collections.singletonMap("from", matrixDotGradleFile));
        }
        finally {
            project.getConvention().getPlugins().remove(MATRIX_NODE_CONVENTION_KEY);
        }
    }

    @Override
    public Configuration getTestingRuntimeConfiguration() {
        return this.jdbcDependencies;
    }

    private class ConventionImpl {
        private final Configuration jdbcDependencies;
        private final Project project;

        private ConventionImpl(Configuration jdbcDependencies, Project project) {
            this.jdbcDependencies = jdbcDependencies;
            this.project = project;
        }

        public void jdbcDependency(Object dependencyNotation, Closure closure) {
            this.project.getDependencies().add(this.jdbcDependencies.getName(), dependencyNotation, closure);
        }

        public void jdbcDependency(Object dependencyNotation) {
            this.project.getDependencies().add(this.jdbcDependencies.getName(), dependencyNotation);
        }
    }
}

