/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.inject;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstantAttribute;
import javassist.bytecode.FieldInfo;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.build.gradle.inject.InjectionException;
import org.hibernate.build.gradle.inject.TargetMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionAction
implements Action<Task> {
    private static final Logger log = LoggerFactory.getLogger(InjectionAction.class);
    private LoaderClassPath loaderClassPath;
    private ClassPool classPool;
    private final Project project;
    private List<TargetMember> targetMembers = new ArrayList<TargetMember>();

    public InjectionAction(Project project) {
        this.project = project;
    }

    public void into(String className, String member) {
        this.into(new TargetMember(className, member));
    }

    private void into(TargetMember targetMember) {
        this.targetMembers.add(targetMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) {
        ClassLoader runtimeScopeClassLoader = this.buildRuntimeScopeClassLoader();
        this.loaderClassPath = new LoaderClassPath(runtimeScopeClassLoader);
        this.classPool = new ClassPool(true);
        this.classPool.appendClassPath((ClassPath)this.loaderClassPath);
        try {
            this.performInjections();
        }
        finally {
            this.loaderClassPath.close();
        }
    }

    private ClassLoader buildRuntimeScopeClassLoader() {
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        SourceSet mainSourceSet = (SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().findByName("main");
        for (File file : mainSourceSet.getRuntimeClasspath()) {
            try {
                classPathUrls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new InjectionException("Could not determine artifact URL [" + file.getPath() + "]", e);
            }
        }
        return new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]), this.getClass().getClassLoader());
    }

    private void performInjections() {
        String projectVersion = this.project.getVersion().toString();
        for (TargetMember targetMember : this.targetMembers) {
            this.resolveInjectionTarget(targetMember).inject(projectVersion);
        }
    }

    private InjectionTarget resolveInjectionTarget(TargetMember targetMember) {
        try {
            CtClass ctClass = this.classPool.get(targetMember.getClassName());
            try {
                CtField field = ctClass.getField(targetMember.getMemberName());
                return new FieldInjectionTarget(targetMember, ctClass, field);
            }
            catch (NotFoundException ignore) {
                for (CtMethod method : ctClass.getMethods()) {
                    if (!method.getName().equals(targetMember.getMemberName())) continue;
                    return new MethodInjectionTarget(targetMember, ctClass, method);
                }
                throw new InjectionException("Unknown member [" + targetMember.getQualifiedName() + "]");
            }
        }
        catch (Throwable e) {
            throw new InjectionException("Unable to resolve class [" + targetMember.getClassName() + "]", e);
        }
    }

    private class MethodInjectionTarget
    extends BaseInjectionTarget {
        private final CtMethod ctMethod;

        private MethodInjectionTarget(TargetMember targetMember, CtClass ctClass, CtMethod ctMethod) {
            super(targetMember, ctClass);
            this.ctMethod = ctMethod;
        }

        @Override
        protected void doInjection(String value) {
            try {
                this.ctMethod.setBody("{return \"" + value + "\";}");
            }
            catch (Throwable t) {
                throw new InjectionException("Unable to replace method body", t);
            }
        }
    }

    private class FieldInjectionTarget
    extends BaseInjectionTarget {
        private final CtField ctField;

        private FieldInjectionTarget(TargetMember targetMember, CtClass ctClass, CtField ctField) {
            super(targetMember, ctClass);
            this.ctField = ctField;
            if (!Modifier.isStatic((int)ctField.getModifiers())) {
                throw new InjectionException("Field is not static [" + targetMember.getQualifiedName() + "]");
            }
        }

        @Override
        protected void doInjection(String value) {
            FieldInfo ctFieldInfo = this.ctField.getFieldInfo();
            ctFieldInfo.addAttribute((AttributeInfo)new ConstantAttribute(ctFieldInfo.getConstPool(), ctFieldInfo.getConstPool().addStringInfo(value)));
        }
    }

    private abstract class BaseInjectionTarget
    implements InjectionTarget {
        private final TargetMember targetMember;
        private final CtClass ctClass;
        private final File classFileLocation;

        protected BaseInjectionTarget(TargetMember targetMember, CtClass ctClass) {
            this.targetMember = targetMember;
            this.ctClass = ctClass;
            try {
                this.classFileLocation = new File(InjectionAction.this.loaderClassPath.find(targetMember.getClassName()).toURI());
            }
            catch (Throwable e) {
                throw new InjectionException("Unable to resolve class file path", e);
            }
        }

        @Override
        public void inject(String value) {
            this.doInjection(value);
            this.writeOutChanges();
        }

        protected abstract void doInjection(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeOutChanges() {
            log.info("writing injection changes back [" + this.classFileLocation.getAbsolutePath() + "]");
            long timeStamp = this.classFileLocation.lastModified();
            ClassFile classFile = this.ctClass.getClassFile();
            classFile.compact();
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.classFileLocation)));
                try {
                    classFile.write(out);
                    out.flush();
                    if (!this.classFileLocation.setLastModified(System.currentTimeMillis())) {
                        log.info("Unable to manually update class file timestamp");
                    }
                }
                finally {
                    out.close();
                    this.classFileLocation.setLastModified(timeStamp);
                }
            }
            catch (IOException e) {
                throw new InjectionException("Unable to write out modified class file", e);
            }
        }
    }

    private static interface InjectionTarget {
        public void inject(String var1);
    }
}

