/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.StackLogger;
import gov.nist.core.ThreadAuditor;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.BlockingQueueDispatchAuditor;
import gov.nist.javax.sip.stack.DatagramQueuedMessageDispatch;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.UDPMessageChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sip.IOExceptionEvent;
import javax.sip.SipListener;

public class UDPMessageProcessor
extends MessageProcessor
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(UDPMessageProcessor.class);
    private int port;
    protected BlockingQueue<DatagramQueuedMessageDispatch> messageQueue;
    BlockingQueueDispatchAuditor congestionAuditor;
    protected LinkedList messageChannels;
    protected int threadPoolSize;
    protected DatagramSocket sock;
    protected boolean isRunning;
    private static final int HIGHWAT = 5000;
    private static final int LOWAT = 2500;
    private int maxMessageSize = SipStackImpl.MAX_DATAGRAM_SIZE;
    private int exceptionsReportedCounter;
    private static final int MAX_EXCEPTIONS_TO_REPORT = 10;

    protected UDPMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) throws IOException {
        super(ipAddress, port, "udp", sipStack);
        this.sipStack = sipStack;
        if (sipStack.getMaxMessageSize() < SipStackImpl.MAX_DATAGRAM_SIZE && sipStack.getMaxMessageSize() > 0) {
            this.maxMessageSize = sipStack.getMaxMessageSize();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Max Message size is " + this.maxMessageSize);
        }
        this.messageQueue = new LinkedBlockingQueue<DatagramQueuedMessageDispatch>();
        if (sipStack.getStackCongestionControlTimeout() > 0) {
            this.congestionAuditor = new BlockingQueueDispatchAuditor(this.messageQueue);
            this.congestionAuditor.setTimeout(sipStack.getStackCongestionControlTimeout());
            this.congestionAuditor.start(2000);
        }
        this.port = port;
        try {
            this.sock = sipStack.getNetworkLayer().createDatagramSocket(port, ipAddress);
            this.sock.setReceiveBufferSize(sipStack.getReceiveUdpBufferSize());
            this.sock.setSendBufferSize(sipStack.getSendUdpBufferSize());
            if (sipStack.getThreadAuditor() != null && sipStack.getThreadAuditor().isEnabled()) {
                this.sock.setSoTimeout((int)sipStack.getThreadAuditor().getPingIntervalInMillisecs());
            }
            if (ipAddress.getHostAddress().equals("0.0.0.0") || ipAddress.getHostAddress().equals("::0")) {
                super.setIpAddress(this.sock.getLocalAddress());
            }
        }
        catch (Exception ex) {
            if (this.congestionAuditor != null) {
                this.congestionAuditor.stop();
            }
            throw new IOException(ex);
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() throws IOException {
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("MessageProcessorThread-UDP-" + this.getIpAddress().getHostAddress() + '/' + this.getPort());
        thread.setPriority(this.sipStack.getThreadPriority());
        thread.start();
    }

    @Override
    public void run() {
        this.messageChannels = new LinkedList();
        if (this.sipStack.threadPoolSize != -1) {
            for (int i = 0; i < this.sipStack.threadPoolSize; ++i) {
                UDPMessageChannel channel = new UDPMessageChannel(this.sipStack, this, ((SipStackImpl)this.sipStack).getStackName() + "-UDPMessageChannelThread-" + i);
                this.messageChannels.add(channel);
            }
        }
        ThreadAuditor.ThreadHandle threadHandle = null;
        if (this.sipStack.getThreadAuditor() != null) {
            threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
        }
        while (this.isRunning) {
            try {
                if (threadHandle != null) {
                    threadHandle.ping();
                }
                int bufsize = this.maxMessageSize;
                byte[] message = new byte[bufsize];
                DatagramPacket packet = new DatagramPacket(message, bufsize);
                this.sock.receive(packet);
                if (this.sipStack.threadPoolSize != -1) {
                    this.messageQueue.offer(new DatagramQueuedMessageDispatch(packet, System.currentTimeMillis()));
                } else {
                    new UDPMessageChannel(this.sipStack, this, packet);
                }
                this.exceptionsReportedCounter = 0;
            }
            catch (SocketTimeoutException bufsize) {
            }
            catch (SocketException ex) {
                if (!this.isRunning) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("UDPMessageProcessor: Stopping");
                    }
                    return;
                }
                this.reportSockeException(ex);
            }
            catch (IOException ex) {
                this.reportSockeException(ex);
            }
            catch (Exception ex) {
                this.reportSockeException(ex);
            }
        }
    }

    private void reportSockeException(Exception e) {
        if (this.exceptionsReportedCounter < 10) {
            ++this.exceptionsReportedCounter;
            boolean lastBeforeFloodingChecker = this.exceptionsReportedCounter == 10;
            String msg = String.format("Caught '%s' on UDP receive socket on %s:%s, message '%s'. Trying to ignore it ... %s", e.getClass().getSimpleName(), this.sock.getLocalAddress().getHostAddress(), this.getPort(), e.getMessage(), lastBeforeFloodingChecker ? "(Flooding checker active, no more socket IO-exceptions will be reported)" : "");
            logger.logWarning(msg);
            logger.logException(e);
            SipListener listener = this.sipStack.getSipListener();
            if (listener != null) {
                listener.processIOException((IOExceptionEvent)new SocketIOExceptionEvent(msg));
            }
        }
    }

    @Override
    public void stop() {
        this.isRunning = false;
        this.sock.close();
        for (Object messageChannel : this.messageChannels) {
            ((MessageChannel)messageChannel).close();
        }
        if (this.sipStack.getStackCongestionControlTimeout() > 0 && this.congestionAuditor != null) {
            this.congestionAuditor.stop();
        }
    }

    @Override
    public String getTransport() {
        return "udp";
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    @Override
    public MessageChannel createMessageChannel(HostPort targetHostPort) throws UnknownHostException {
        return new UDPMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
    }

    @Override
    public MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        return new UDPMessageChannel(host, port, this.sipStack, this);
    }

    @Override
    public int getDefaultTargetPort() {
        return 5060;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public int getMaximumMessageSize() {
        return this.sipStack.getReceiveUdpBufferSize();
    }

    @Override
    public boolean inUse() {
        return !this.messageQueue.isEmpty();
    }

    private class SocketIOExceptionEvent
    extends IOExceptionEvent {
        private static final long serialVersionUID = 778500971662697296L;
        private final String msg;

        public SocketIOExceptionEvent(String msg) {
            super((Object)UDPMessageProcessor.this, UDPMessageProcessor.this.sock.getLocalAddress().getHostAddress(), UDPMessageProcessor.this.port, UDPMessageProcessor.this.transport);
            this.msg = msg;
        }

        public String toString() {
            return this.msg;
        }
    }
}

