/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.Client;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerStartupLoggingIT
extends ExclusiveServerTestBase {
    private static ByteArrayOutputStream out;
    private static NeoServer server;

    @BeforeClass
    public static void setupServer() throws IOException {
        out = new ByteArrayOutputStream();
        server = ServerHelper.createNonPersistentServer((LogProvider)FormattedLogProvider.toOutputStream((OutputStream)out));
    }

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase(server);
    }

    @AfterClass
    public static void stopServer() {
        server.stop();
    }

    @Test
    public void shouldLogStartup() {
        String logContent = out.toString();
        Assert.assertThat((Object)logContent.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)logContent, (Matcher)Matchers.containsString((String)AbstractNeoServer.NEO4J_IS_STARTING_MESSAGE));
        Client nonRedirectingClient = Client.create();
        nonRedirectingClient.setFollowRedirects(Boolean.valueOf(false));
        JaxRsResponse response = new RestRequest(server.baseUri(), nonRedirectingClient).get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(199))));
    }
}

