/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.StringKeyObjectValueIgnoreCaseMultivaluedMap;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.management.console.ConsoleService;
import org.neo4j.server.rest.management.repr.ServerRootRepresentation;

public class JaxRsResponse
extends Response {
    private final int status;
    private final MultivaluedMap<String, Object> metaData;
    private final MultivaluedMap<String, String> headers;
    private final URI location;
    private String data;
    private MediaType type;

    public JaxRsResponse(ClientResponse response) {
        this(response, JaxRsResponse.extractContent(response));
    }

    public JaxRsResponse(ClientResponse response, String entity) {
        this.status = response.getStatus();
        this.metaData = this.extractMetaData(response);
        this.headers = this.extractHeaders(response);
        this.location = response.getLocation();
        this.type = response.getType();
        this.data = entity;
        response.close();
    }

    private static String extractContent(ClientResponse response) {
        if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return null;
        }
        return (String)response.getEntity(String.class);
    }

    public static JaxRsResponse extractFrom(ClientResponse clientResponse) {
        return new JaxRsResponse(clientResponse);
    }

    public String getEntity() {
        return this.data;
    }

    public int getStatus() {
        return this.status;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.metaData;
    }

    private MultivaluedMap<String, Object> extractMetaData(ClientResponse jettyResponse) {
        StringKeyObjectValueIgnoreCaseMultivaluedMap metadata = new StringKeyObjectValueIgnoreCaseMultivaluedMap();
        for (Map.Entry header : jettyResponse.getHeaders().entrySet()) {
            for (Object value : (List)header.getValue()) {
                metadata.putSingle(header.getKey(), value);
            }
        }
        return metadata;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    private MultivaluedMap<String, String> extractHeaders(ClientResponse jettyResponse) {
        return jettyResponse.getHeaders();
    }

    public URI getLocation() {
        return this.location;
    }

    public void close() {
    }

    public MediaType getType() {
        return this.type;
    }

    public static class ServerRootRepresentationTest {
        @Test
        public void shouldProvideAListOfServiceUris() throws Exception {
            ConsoleService consoleService = new ConsoleService(null, (Database)Mockito.mock(Database.class), (LogProvider)NullLogProvider.getInstance(), null);
            ServerRootRepresentation srr = new ServerRootRepresentation(new URI("http://example.org:9999"), Collections.singletonList(consoleService));
            Map map = srr.serialize();
            Assert.assertNotNull(map.get("services"));
            Assert.assertThat(((Map)map.get("services")).get(consoleService.getName()), (Matcher)Matchers.containsString((String)consoleService.getServerPath()));
        }
    }
}

