/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;

public class RemoveRelationshipIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(RemoveRelationshipIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Test
    public void shouldGet204WhenRemovingAValidRelationship() throws Exception {
        long relationshipId = helper.createRelationship("KNOWS");
        JaxRsResponse response = this.sendDeleteRequest(new URI(functionalTestHelper.relationshipUri(relationshipId)));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGet404WhenRemovingAnInvalidRelationship() throws Exception {
        long relationshipId = helper.createRelationship("KNOWS");
        JaxRsResponse response = this.sendDeleteRequest(new URI(functionalTestHelper.relationshipUri((relationshipId + 1L) * 9999L)));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    private JaxRsResponse sendDeleteRequest(URI requestUri) {
        return RestRequest.req().delete(requestUri);
    }
}

