/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.nio.file.Path;
import org.neo4j.backup.impl.AddressResolver;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.BackupStageOutcome;
import org.neo4j.backup.impl.BackupStrategy;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.com.ComException;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class HaBackupStrategy
extends LifecycleAdapter
implements BackupStrategy {
    private final BackupProtocolService backupProtocolService;
    private final AddressResolver addressResolver;
    private final long timeout;
    private final Log log;

    HaBackupStrategy(BackupProtocolService backupProtocolService, AddressResolver addressResolver, LogProvider logProvider, long timeout) {
        this.backupProtocolService = backupProtocolService;
        this.addressResolver = addressResolver;
        this.timeout = timeout;
        this.log = logProvider.getLog(HaBackupStrategy.class);
    }

    @Override
    public Fallible<BackupStageOutcome> performIncrementalBackup(Path backupDestination, Config config, OptionalHostnamePort fromAddress) {
        HostnamePort resolvedAddress = this.addressResolver.resolveCorrectHAAddress(config, fromAddress);
        this.log.info("Resolved address for backup protocol is " + resolvedAddress);
        try {
            String host = resolvedAddress.getHost();
            int port = resolvedAddress.getPort();
            this.backupProtocolService.doIncrementalBackup(host, port, backupDestination, ConsistencyCheck.NONE, this.timeout, config);
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.SUCCESS, null);
        }
        catch (MismatchingStoreIdException e) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.UNRECOVERABLE_FAILURE, e);
        }
        catch (RuntimeException e) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.FAILURE, e);
        }
    }

    @Override
    public Fallible<BackupStageOutcome> performFullBackup(Path desiredBackupLocation, Config config, OptionalHostnamePort userProvidedAddress) {
        HostnamePort fromAddress = this.addressResolver.resolveCorrectHAAddress(config, userProvidedAddress);
        this.log.info("Resolved address for backup protocol is " + fromAddress);
        ConsistencyCheck consistencyCheck = ConsistencyCheck.NONE;
        boolean forensics = false;
        try {
            String host = fromAddress.getHost();
            int port = fromAddress.getPort();
            this.backupProtocolService.doFullBackup(host, port, desiredBackupLocation, consistencyCheck, config, this.timeout, forensics);
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.SUCCESS, null);
        }
        catch (ComException e) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.WRONG_PROTOCOL, e);
        }
    }
}

