/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStream;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamProvider;

public class InMemoryStoreStreamProvider
implements StoreFileStreamProvider {
    private Map<String, StringBuffer> fileStreams = new HashMap<String, StringBuffer>();

    public StoreFileStream acquire(String destination, int requiredAlignment) {
        this.fileStreams.putIfAbsent(destination, new StringBuffer());
        return new InMemoryStoreStream(this.fileStreams.get(destination));
    }

    public Map<String, StringBuffer> fileStreams() {
        return this.fileStreams;
    }

    class InMemoryStoreStream
    implements StoreFileStream {
        private StringBuffer stringBuffer;

        InMemoryStoreStream(StringBuffer stringBuffer) {
            this.stringBuffer = stringBuffer;
        }

        public void write(byte[] data) {
            for (byte b : data) {
                this.stringBuffer.append((char)b);
            }
        }

        public void close() {
        }
    }
}

