/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.HostnamePortAsListenAddress;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;

public class HostnamePortAsListenAddressTest {
    @Test
    public void shouldIgnoreRange() {
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, "localhost:4343-4347").build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)new ListenSocketAddress("localhost", 4343), (Object)listenSocketAddress);
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldThrowInvalidSettingsExceptionOnEmptyConfig() {
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, "").build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)OnlineBackupSettings.online_backup_server.getDefaultValue(), (Object)listenSocketAddress.toString());
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldThrowInvalidSettingsExceptionOnBadFormat() {
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, "localhost").build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)OnlineBackupSettings.online_backup_server.getDefaultValue(), (Object)listenSocketAddress.toString());
    }

    @Test
    public void shouldHandleIpv4() {
        String ipv4host = "localhost";
        int port = 1234;
        String ipv4 = ipv4host + ":" + port;
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, ipv4).build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)new ListenSocketAddress(ipv4host, port), (Object)listenSocketAddress);
    }

    @Test
    public void shouldHandleIpv6() {
        String ipv6host = "2001:cdba:0000:0000:0000:0000:3257:9652";
        int port = 1234;
        String ipv6 = '[' + ipv6host + "]:" + port;
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, ipv6).build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)new ListenSocketAddress(ipv6host, port), (Object)listenSocketAddress);
    }
}

