/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.election;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.causalclustering.core.consensus.LeaderListener;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.Iterables;

public class ElectionUtil {
    private ElectionUtil() {
    }

    public static MemberId waitForLeaderAgreement(Iterable<RaftMachine> validRafts, long maxTimeMillis) throws InterruptedException, TimeoutException {
        long viewCount = Iterables.count(validRafts);
        HashMap<MemberId, MemberId> leaderViews = new HashMap<MemberId, MemberId>();
        CompletableFuture<MemberId> futureAgreedLeader = new CompletableFuture<MemberId>();
        ArrayList<Runnable> destructors = new ArrayList<Runnable>();
        for (RaftMachine raft : validRafts) {
            destructors.add(ElectionUtil.leaderViewUpdatingListener(raft, validRafts, leaderViews, viewCount, futureAgreedLeader));
        }
        try {
            MemberId memberId = (MemberId)futureAgreedLeader.get(maxTimeMillis, TimeUnit.MILLISECONDS);
            return memberId;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            destructors.forEach(Runnable::run);
        }
    }

    private static Runnable leaderViewUpdatingListener(RaftMachine raft, Iterable<RaftMachine> validRafts, Map<MemberId, MemberId> leaderViews, long viewCount, CompletableFuture<MemberId> futureAgreedLeader) {
        LeaderListener listener = newLeader -> {
            Map map = leaderViews;
            synchronized (map) {
                leaderViews.put(raft.identity(), newLeader.memberId());
                boolean leaderIsValid = false;
                for (RaftMachine validRaft : validRafts) {
                    if (!validRaft.identity().equals((Object)newLeader.memberId())) continue;
                    leaderIsValid = true;
                }
                if (newLeader.memberId() != null && leaderIsValid && ElectionUtil.allAgreeOnLeader(leaderViews, viewCount, newLeader.memberId())) {
                    futureAgreedLeader.complete(newLeader.memberId());
                }
            }
        };
        raft.registerListener(listener);
        return () -> raft.unregisterListener(listener);
    }

    private static <T> boolean allAgreeOnLeader(Map<T, T> leaderViews, long viewCount, T leader) {
        if ((long)leaderViews.size() != viewCount) {
            return false;
        }
        for (T leaderView : leaderViews.values()) {
            if (leader.equals(leaderView)) continue;
            return false;
        }
        return true;
    }
}

