/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.outcome.TruncateLogCommand;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class TruncateLogCommandTest {
    @Test
    public void applyTo() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        long fromIndex = 2L;
        TruncateLogCommand truncateLogCommand = new TruncateLogCommand(fromIndex);
        ConsecutiveInFlightCache inFlightCache = new ConsecutiveInFlightCache();
        inFlightCache.put(0L, new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0)));
        inFlightCache.put(1L, new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1)));
        inFlightCache.put(2L, new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2)));
        inFlightCache.put(3L, new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(3)));
        truncateLogCommand.applyTo((InFlightCache)inFlightCache, log);
        Assert.assertNotNull((Object)inFlightCache.get(0L));
        Assert.assertNotNull((Object)inFlightCache.get(1L));
        Assert.assertNull((Object)inFlightCache.get(2L));
        Assert.assertNull((Object)inFlightCache.get(3L));
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).debug("Start truncating in-flight-map from index %d. Current map:%n%s", new Object[]{fromIndex, inFlightCache})});
    }

    @Test
    public void shouldTruncateWithGaps() {
        long fromIndex = 1L;
        TruncateLogCommand truncateLogCommand = new TruncateLogCommand(fromIndex);
        ConsecutiveInFlightCache inFlightCache = new ConsecutiveInFlightCache();
        inFlightCache.put(0L, new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0)));
        inFlightCache.put(2L, new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1)));
        inFlightCache.put(4L, new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2)));
        truncateLogCommand.applyTo((InFlightCache)inFlightCache, (Log)NullLog.getInstance());
        inFlightCache.put(1L, new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(1)));
        inFlightCache.put(2L, new RaftLogEntry(4L, (ReplicatedContent)ReplicatedInteger.valueOf(2)));
        Assert.assertNotNull((Object)inFlightCache.get(1L));
        Assert.assertNotNull((Object)inFlightCache.get(2L));
    }
}

