/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.outcome.TruncateLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.Appending;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class AppendingTest {
    private MemberId aMember = RaftTestMember.member(0);

    @Test
    public void shouldPerformTruncation() throws Exception {
        long appendIndex = 5L;
        long localTermForAllEntries = 1L;
        Outcome outcome = (Outcome)Mockito.mock(Outcome.class);
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        Mockito.when((Object)logMock.readEntryTerm(ArgumentMatchers.anyLong())).thenReturn((Object)localTermForAllEntries);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)appendIndex);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)(appendIndex - 3L));
        Appending.handleAppendEntriesRequest((ReadableRaftState)state, (Outcome)outcome, (RaftMessages.AppendEntries.Request)new RaftMessages.AppendEntries.Request(this.aMember, localTermForAllEntries, appendIndex - 2L, localTermForAllEntries, new RaftLogEntry[]{new RaftLogEntry(localTermForAllEntries + 1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))}, appendIndex + 3L), (Log)NullLog.getInstance());
        ((Outcome)Mockito.verify((Object)outcome, (VerificationMode)Mockito.times((int)1))).addLogCommand((RaftLogCommand)MockitoHamcrest.argThat((Matcher)new LogCommandMatcher(appendIndex - 1L)));
    }

    @Test
    public void shouldNotAllowTruncationAtCommit() throws Exception {
        long commitIndex = 5L;
        long localTermForAllEntries = 1L;
        Outcome outcome = (Outcome)Mockito.mock(Outcome.class);
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        Mockito.when((Object)logMock.readEntryTerm(ArgumentMatchers.anyLong())).thenReturn((Object)localTermForAllEntries);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)commitIndex);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)commitIndex);
        try {
            Appending.handleAppendEntriesRequest((ReadableRaftState)state, (Outcome)outcome, (RaftMessages.AppendEntries.Request)new RaftMessages.AppendEntries.Request(this.aMember, localTermForAllEntries, commitIndex - 1L, localTermForAllEntries, new RaftLogEntry[]{new RaftLogEntry(localTermForAllEntries + 1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))}, commitIndex + 3L), (Log)NullLog.getInstance());
            Assert.fail((String)"Appending should not allow truncation at or before the commit index");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowTruncationBeforeCommit() throws Exception {
        long commitIndex = 5L;
        long localTermForAllEntries = 1L;
        Outcome outcome = (Outcome)Mockito.mock(Outcome.class);
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        Mockito.when((Object)logMock.readEntryTerm(ArgumentMatchers.anyLong())).thenReturn((Object)localTermForAllEntries);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)commitIndex);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)commitIndex);
        try {
            Appending.handleAppendEntriesRequest((ReadableRaftState)state, (Outcome)outcome, (RaftMessages.AppendEntries.Request)new RaftMessages.AppendEntries.Request(this.aMember, localTermForAllEntries, commitIndex - 2L, localTermForAllEntries, new RaftLogEntry[]{new RaftLogEntry(localTermForAllEntries + 1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))}, commitIndex + 3L), (Log)NullLog.getInstance());
            Assert.fail((String)"Appending should not allow truncation at or before the commit index");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAttemptToTruncateAtIndexBeforeTheLogPrevIndex() throws Exception {
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        long prevIndex = 5L;
        long prevTerm = 5L;
        Mockito.when((Object)logMock.prevIndex()).thenReturn((Object)prevIndex);
        Mockito.when((Object)logMock.readEntryTerm(prevIndex)).thenReturn((Object)prevTerm);
        Mockito.when((Object)logMock.readEntryTerm(prevIndex - 2L)).thenReturn((Object)-1L);
        long commitIndex = 10L;
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)commitIndex);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)commitIndex);
        Outcome outcome = (Outcome)Mockito.mock(Outcome.class);
        Appending.handleAppendEntriesRequest((ReadableRaftState)state, (Outcome)outcome, (RaftMessages.AppendEntries.Request)new RaftMessages.AppendEntries.Request(this.aMember, prevTerm, prevIndex - 2L, prevTerm, new RaftLogEntry[]{new RaftLogEntry(prevTerm, (ReplicatedContent)ReplicatedInteger.valueOf(2))}, commitIndex + 3L), (Log)NullLog.getInstance());
        ((Outcome)Mockito.verify((Object)outcome, (VerificationMode)Mockito.never())).addLogCommand((RaftLogCommand)ArgumentMatchers.any());
    }

    private static class LogCommandMatcher
    extends TypeSafeMatcher<RaftLogCommand> {
        private final long truncateIndex;

        private LogCommandMatcher(long truncateIndex) {
            this.truncateIndex = truncateIndex;
        }

        protected boolean matchesSafely(RaftLogCommand item) {
            return item instanceof TruncateLogCommand && ((TruncateLogCommand)item).fromIndex == this.truncateIndex;
        }

        public void describeTo(Description description) {
            description.appendText(new TruncateLogCommand(this.truncateIndex).toString());
        }
    }
}

