/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.vote;

import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.MemberId;

public abstract class AnyVoteResponseBuilder<T extends RaftMessages.AnyVote.Response> {
    private boolean voteGranted;
    private long term = -1L;
    private MemberId from;
    private final Constructor<T> constructor;

    protected AnyVoteResponseBuilder(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public T build() {
        return this.constructor.construct(this.from, this.term, this.voteGranted);
    }

    public AnyVoteResponseBuilder<T> from(MemberId from) {
        this.from = from;
        return this;
    }

    public AnyVoteResponseBuilder<T> term(long term) {
        this.term = term;
        return this;
    }

    public AnyVoteResponseBuilder<T> grant() {
        this.voteGranted = true;
        return this;
    }

    public AnyVoteResponseBuilder<T> deny() {
        this.voteGranted = false;
        return this;
    }

    @FunctionalInterface
    static interface Constructor<T extends RaftMessages.AnyVote.Response> {
        public T construct(MemberId var1, long var2, boolean var4);
    }
}

