/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.Progress;
import org.neo4j.causalclustering.core.replication.ProgressTrackerImpl;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.Result;

public class ProgressTrackerImplTest {
    private final int DEFAULT_TIMEOUT_MS = 15000;
    private GlobalSession session = new GlobalSession(UUID.randomUUID(), null);
    private DistributedOperation operationA = new DistributedOperation((ReplicatedContent)ReplicatedInteger.valueOf(0), this.session, new LocalOperationId(0L, 0L));
    private DistributedOperation operationB = new DistributedOperation((ReplicatedContent)ReplicatedInteger.valueOf(1), this.session, new LocalOperationId(1L, 0L));
    private ProgressTrackerImpl tracker = new ProgressTrackerImpl(this.session);

    @Test
    public void shouldReportThatOperationIsNotReplicatedInitially() {
        Progress progress = this.tracker.start(this.operationA);
        Assert.assertEquals((Object)false, (Object)progress.isReplicated());
    }

    @Test
    public void shouldWaitForReplication() throws Exception {
        Progress progress = this.tracker.start(this.operationA);
        long time = System.currentTimeMillis();
        progress.awaitReplication(10L);
        time = System.currentTimeMillis() - time;
        Assert.assertThat((Object)time, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(10L)));
    }

    @Test
    public void shouldStopWaitingWhenReplicated() throws Exception {
        Progress progress = this.tracker.start(this.operationA);
        Thread waiter = this.replicationEventWaiter(progress);
        Assert.assertEquals((Object)true, (Object)waiter.isAlive());
        Assert.assertEquals((Object)false, (Object)progress.isReplicated());
        this.tracker.trackReplication(this.operationA);
        Assert.assertEquals((Object)true, (Object)progress.isReplicated());
        waiter.join(15000L);
        Assert.assertEquals((Object)false, (Object)waiter.isAlive());
    }

    @Test
    public void shouldBeAbleToAbortTracking() {
        this.tracker.start(this.operationA);
        Assert.assertEquals((long)1L, (long)this.tracker.inProgressCount());
        this.tracker.abort(this.operationA);
        Assert.assertEquals((long)0L, (long)this.tracker.inProgressCount());
    }

    @Test
    public void shouldCheckThatOneOperationDoesNotAffectProgressOfOther() {
        Progress progressA = this.tracker.start(this.operationA);
        Progress progressB = this.tracker.start(this.operationB);
        this.tracker.trackReplication(this.operationA);
        Assert.assertEquals((Object)true, (Object)progressA.isReplicated());
        Assert.assertEquals((Object)false, (Object)progressB.isReplicated());
    }

    @Test
    public void shouldTriggerReplicationEvent() throws Exception {
        Progress progress = this.tracker.start(this.operationA);
        Thread waiter = this.replicationEventWaiter(progress);
        this.tracker.triggerReplicationEvent();
        Assert.assertEquals((Object)false, (Object)progress.isReplicated());
        waiter.join();
        Assert.assertEquals((Object)false, (Object)waiter.isAlive());
    }

    @Test
    public void shouldGetTrackedResult() throws Exception {
        Progress progress = this.tracker.start(this.operationA);
        String result = "result";
        this.tracker.trackResult(this.operationA, Result.of((Object)result));
        Assert.assertEquals((Object)result, progress.futureResult().get(15000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void shouldIgnoreOtherSessions() {
        GlobalSession sessionB = new GlobalSession(UUID.randomUUID(), null);
        DistributedOperation aliasUnderSessionB = new DistributedOperation((ReplicatedContent)ReplicatedInteger.valueOf(0), sessionB, new LocalOperationId(this.operationA.operationId().localSessionId(), this.operationA.operationId().sequenceNumber()));
        Progress progressA = this.tracker.start(this.operationA);
        this.tracker.trackReplication(aliasUnderSessionB);
        this.tracker.trackResult(aliasUnderSessionB, Result.of((Object)"result"));
        Assert.assertEquals((Object)false, (Object)progressA.isReplicated());
        Assert.assertEquals((Object)false, (Object)progressA.futureResult().isDone());
    }

    private Thread replicationEventWaiter(Progress progress) {
        Thread waiter = new Thread(() -> {
            try {
                progress.awaitReplication(15000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        waiter.start();
        return waiter;
    }
}

