/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication.session;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.replication.session.OperationContext;
import org.neo4j.causalclustering.identity.MemberId;

public class LocalSessionPoolTest {
    private MemberId memberId = new MemberId(UUID.randomUUID());
    private GlobalSession globalSession = new GlobalSession(UUID.randomUUID(), this.memberId);

    @Test
    public void poolGivesBackSameSessionAfterRelease() {
        LocalSessionPool sessionPool = new LocalSessionPool(this.globalSession);
        OperationContext contextA = sessionPool.acquireSession();
        sessionPool.releaseSession(contextA);
        OperationContext contextB = sessionPool.acquireSession();
        sessionPool.releaseSession(contextB);
        Assert.assertEquals((Object)contextA.localSession(), (Object)contextB.localSession());
    }

    @Test
    public void sessionAcquirementIncreasesOperationId() {
        LocalSessionPool sessionPool = new LocalSessionPool(this.globalSession);
        OperationContext context = sessionPool.acquireSession();
        LocalOperationId operationA = context.localOperationId();
        sessionPool.releaseSession(context);
        context = sessionPool.acquireSession();
        LocalOperationId operationB = context.localOperationId();
        sessionPool.releaseSession(context);
        Assert.assertEquals((long)operationB.sequenceNumber(), (long)(operationA.sequenceNumber() + 1L));
    }

    @Test
    public void poolHasIndependentSessions() {
        LocalSessionPool sessionPool = new LocalSessionPool(this.globalSession);
        OperationContext contextA = sessionPool.acquireSession();
        OperationContext contextB = sessionPool.acquireSession();
        Assert.assertNotEquals((Object)contextA.localSession(), (Object)contextB.localSession());
    }
}

