/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.replication.DirectReplicator;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationStateMachine;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGenerator;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class ReplicatedIdRangeAcquirerTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public FileSystemRule defaultFileSystemRule = new DefaultFileSystemRule();
    private final MemberId memberA = new MemberId(UUID.randomUUID());
    private final MemberId memberB = new MemberId(UUID.randomUUID());
    private final ReplicatedIdAllocationStateMachine idAllocationStateMachine = new ReplicatedIdAllocationStateMachine((StateStorage)new InMemoryStateStorage((Object)new IdAllocationState()));
    private final DirectReplicator<ReplicatedIdAllocationRequest> replicator = new DirectReplicator(this.idAllocationStateMachine);

    @Test
    public void consecutiveAllocationsFromSeparateIdGeneratorsForSameIdTypeShouldNotDuplicateWhenInitialIdIsZero() {
        this.consecutiveAllocationFromSeparateIdGeneratorsForSameIdTypeShouldNotDuplicateForGivenInitialHighId(0L);
    }

    @Test
    public void consecutiveAllocationsFromSeparateIdGeneratorsForSameIdTypeShouldNotDuplicateWhenInitialIdIsNotZero() {
        this.consecutiveAllocationFromSeparateIdGeneratorsForSameIdTypeShouldNotDuplicateForGivenInitialHighId(1L);
    }

    private void consecutiveAllocationFromSeparateIdGeneratorsForSameIdTypeShouldNotDuplicateForGivenInitialHighId(long initialHighId) {
        HashSet<Long> idAllocations = new HashSet<Long>();
        int idRangeLength = 8;
        FileSystemAbstraction fs = this.defaultFileSystemRule.get();
        File generatorFile1 = this.testDirectory.file("gen1");
        File generatorFile2 = this.testDirectory.file("gen2");
        try (ReplicatedIdGenerator generatorOne = this.createForMemberWithInitialIdAndRangeLength(this.memberA, initialHighId, idRangeLength, fs, generatorFile1);
             ReplicatedIdGenerator generatorTwo = this.createForMemberWithInitialIdAndRangeLength(this.memberB, initialHighId, idRangeLength, fs, generatorFile2);){
            boolean wasNew;
            long newId = generatorOne.nextId();
            idAllocations.add(newId);
            int i = 1;
            while ((long)i < (long)idRangeLength - initialHighId) {
                newId = generatorOne.nextId();
                wasNew = idAllocations.add(newId);
                Assert.assertTrue((String)("Id " + newId + " has already been returned"), (boolean)wasNew);
                Assert.assertTrue((String)("Detected gap in id generation, missing " + (newId - 1L)), (boolean)idAllocations.contains(newId - 1L));
                ++i;
            }
            for (i = 0; i < idRangeLength; ++i) {
                newId = generatorTwo.nextId();
                wasNew = idAllocations.add(newId);
                Assert.assertTrue((String)("Id " + newId + " has already been returned"), (boolean)wasNew);
                Assert.assertTrue((String)("Detected gap in id generation, missing " + (newId - 1L)), (boolean)idAllocations.contains(newId - 1L));
            }
        }
    }

    private ReplicatedIdGenerator createForMemberWithInitialIdAndRangeLength(MemberId member, long initialHighId, int idRangeLength, FileSystemAbstraction fs, File file) {
        Map<IdType, Integer> allocationSizes = Arrays.stream(IdType.values()).collect(Collectors.toMap(idType -> idType, idType -> idRangeLength));
        ReplicatedIdRangeAcquirer acquirer = new ReplicatedIdRangeAcquirer(this.replicator, this.idAllocationStateMachine, allocationSizes, member, (LogProvider)NullLogProvider.getInstance());
        return new ReplicatedIdGenerator(fs, file, IdType.ARRAY_BLOCK, () -> initialHighId, acquirer, (LogProvider)NullLogProvider.getInstance(), 10, true);
    }
}

