/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.DnsHostnameResolver;
import org.neo4j.causalclustering.discovery.DomainNameResolver;
import org.neo4j.causalclustering.discovery.MapDomainNameResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class DnsHostnameResolverTest {
    MapDomainNameResolver mockDomainNameResolver = new MapDomainNameResolver(new HashMap());
    AssertableLogProvider logProvider = new AssertableLogProvider();
    AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private DnsHostnameResolver resolver = new DnsHostnameResolver((LogProvider)this.logProvider, (LogProvider)this.userLogProvider, (DomainNameResolver)this.mockDomainNameResolver);

    @Test
    public void hostnamesAreResolvedByTheResolver() {
        this.mockDomainNameResolver.setHostnameAddresses("google.com", Arrays.asList("1.2.3.4", "5.6.7.8"));
        Collection resolvedAddresses = this.resolver.resolve(new AdvertisedSocketAddress("google.com", 80));
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("1.2.3.4")));
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("5.6.7.8")));
    }

    @Test
    public void resolvedHostnamesUseTheSamePort() {
        this.mockDomainNameResolver.setHostnameAddresses("google.com", Arrays.asList("1.2.3.4", "5.6.7.8"));
        ArrayList resolvedAddresses = new ArrayList(this.resolver.resolve(new AdvertisedSocketAddress("google.com", 1234)));
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertEquals((long)1234L, (long)((AdvertisedSocketAddress)resolvedAddresses.get(0)).getPort());
        Assert.assertEquals((long)1234L, (long)((AdvertisedSocketAddress)resolvedAddresses.get(1)).getPort());
    }

    @Test
    public void resolutionDetailsAreLoggedToUserLogs() {
        this.mockDomainNameResolver.setHostnameAddresses("google.com", Arrays.asList("1.2.3.4", "5.6.7.8"));
        this.resolver.resolve(new AdvertisedSocketAddress("google.com", 1234));
        this.userLogProvider.assertContainsMessageContaining("Resolved initial host '%s' to %s");
    }

    @Test
    public void unknownHostExceptionsAreLoggedAsErrors() {
        this.resolver.resolve(new AdvertisedSocketAddress("google.com", 1234));
        this.logProvider.assertContainsMessageContaining("Failed to resolve host 'google.com'");
    }
}

