/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.helper.StateAwareSuspendableLifeCycle;
import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.causalclustering.helper.SuspendableLifecycleStateTestHelpers;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class SuspendableLifeCycleSuspendedStateChangeTest {
    @Parameterized.Parameter
    public SuspendableLifecycleStateTestHelpers.LifeCycleState fromState;
    @Parameterized.Parameter(value=1)
    public SuspendableLifecycleStateTestHelpers.SuspendedState fromSuspendedState;
    @Parameterized.Parameter(value=2)
    public SuspendableLifecycleStateTestHelpers.SuspendedState toSuspendedState;
    @Parameterized.Parameter(value=3)
    public SuspendableLifecycleStateTestHelpers.LifeCycleState shouldEndInState;
    private StateAwareSuspendableLifeCycle lifeCycle;

    @Parameterized.Parameters(name="From {0} and {1} to {2} should end in {3}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SuspendableLifecycleStateTestHelpers.LifeCycleState lifeCycleState : SuspendableLifecycleStateTestHelpers.LifeCycleState.values()) {
            for (SuspendableLifecycleStateTestHelpers.SuspendedState suspendedState : SuspendableLifecycleStateTestHelpers.SuspendedState.values()) {
                for (SuspendableLifecycleStateTestHelpers.SuspendedState toSuspendedState : SuspendableLifeCycleSuspendedStateChangeTest.toSuspendedState()) {
                    params.add(new Object[]{lifeCycleState, suspendedState, toSuspendedState, SuspendableLifeCycleSuspendedStateChangeTest.expectedResult(lifeCycleState, suspendedState, toSuspendedState)});
                }
            }
        }
        return params;
    }

    private static SuspendableLifecycleStateTestHelpers.SuspendedState[] toSuspendedState() {
        return new SuspendableLifecycleStateTestHelpers.SuspendedState[]{SuspendableLifecycleStateTestHelpers.SuspendedState.Enabled, SuspendableLifecycleStateTestHelpers.SuspendedState.Disabled};
    }

    @Before
    public void setUpServer() throws Throwable {
        this.lifeCycle = new StateAwareSuspendableLifeCycle(NullLogProvider.getInstance().getLog("log"));
        SuspendableLifecycleStateTestHelpers.setInitialState(this.lifeCycle, this.fromState);
        this.fromSuspendedState.set((Suspendable)this.lifeCycle);
    }

    @Test
    public void changeSuspendedState() throws Throwable {
        this.toSuspendedState.set((Suspendable)this.lifeCycle);
        Assert.assertEquals((Object)((Object)this.shouldEndInState), (Object)((Object)this.lifeCycle.status));
    }

    private static SuspendableLifecycleStateTestHelpers.LifeCycleState expectedResult(SuspendableLifecycleStateTestHelpers.LifeCycleState fromState, SuspendableLifecycleStateTestHelpers.SuspendedState fromSuspendedState, SuspendableLifecycleStateTestHelpers.SuspendedState toSuspendedState) {
        if (toSuspendedState == SuspendableLifecycleStateTestHelpers.SuspendedState.Disabled) {
            return SuspendableLifecycleStateTestHelpers.LifeCycleState.Stop;
        }
        if (toSuspendedState == SuspendableLifecycleStateTestHelpers.SuspendedState.Enabled) {
            if (fromSuspendedState == SuspendableLifecycleStateTestHelpers.SuspendedState.Disabled && (fromState == SuspendableLifecycleStateTestHelpers.LifeCycleState.Init || fromState == SuspendableLifecycleStateTestHelpers.LifeCycleState.Shutdown)) {
                return SuspendableLifecycleStateTestHelpers.LifeCycleState.Stop;
            }
            return fromState;
        }
        throw new IllegalStateException("Should not transition to any other state got: " + (Object)((Object)toSuspendedState));
    }
}

