/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.ServerNettyPipelineBuilder;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;

public class NettyPipelineBuilderTest {
    private AssertableLogProvider logProvider = new AssertableLogProvider();
    private Log log = this.logProvider.getLog(this.getClass());
    private EmbeddedChannel channel = new EmbeddedChannel();
    private ChannelHandlerAdapter EMPTY_HANDLER = new ChannelHandlerAdapter(){};

    @Test
    public void shouldLogExceptionInbound() {
        final RuntimeException ex = new RuntimeException();
        ((ServerNettyPipelineBuilder)NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).add("read_handler", new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                throw ex;
            }
        }})).install();
        this.channel.writeOneInbound(new Object());
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).error(Matchers.startsWith((String)"Exception in inbound"), Matchers.equalTo((Object)ex))});
        Assert.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    public void shouldLogUnhandledMessageInbound() {
        Object msg = new Object();
        NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).install();
        this.channel.writeOneInbound(msg);
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).error(Matchers.equalTo((Object)"Unhandled inbound message: %s for channel: %s"), new Object[]{Matchers.equalTo((Object)msg), Matchers.any(Channel.class)})});
        Assert.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    public void shouldLogUnhandledMessageOutbound() {
        Object msg = new Object();
        NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).install();
        this.channel.writeAndFlush(msg);
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).error(Matchers.equalTo((Object)"Unhandled outbound message: %s for channel: %s"), new Object[]{Matchers.equalTo((Object)msg), Matchers.any(Channel.class)})});
        Assert.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    public void shouldLogExceptionOutbound() {
        final RuntimeException ex = new RuntimeException();
        ((ServerNettyPipelineBuilder)NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).add("write_handler", new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                throw ex;
            }
        }})).install();
        this.channel.writeAndFlush(new Object());
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).error(Matchers.startsWith((String)"Exception in outbound"), Matchers.equalTo((Object)ex))});
        Assert.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    public void shouldLogExceptionOutboundWithVoidPromise() {
        final RuntimeException ex = new RuntimeException();
        ((ServerNettyPipelineBuilder)NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).add("write_handler", new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                throw ex;
            }
        }})).install();
        this.channel.writeAndFlush(new Object(), this.channel.voidPromise());
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).error(Matchers.startsWith((String)"Exception in outbound"), Matchers.equalTo((Object)ex))});
        Assert.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    public void shouldNotLogAnythingForHandledInbound() {
        Object msg = new Object();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
            }
        };
        ((ServerNettyPipelineBuilder)NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).add("read_handler", new ChannelHandler[]{handler})).install();
        this.channel.writeOneInbound(msg);
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void shouldNotLogAnythingForHandledOutbound() {
        Object msg = new Object();
        ChannelOutboundHandlerAdapter encoder = new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ctx.write((Object)ctx.alloc().buffer());
            }
        };
        ((ServerNettyPipelineBuilder)NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).add("write_handler", new ChannelHandler[]{encoder})).install();
        this.channel.writeAndFlush(msg);
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void shouldReInstallWithPreviousGate() {
        Object gatedMessage = new Object();
        ServerNettyPipelineBuilder builderA = NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log);
        builderA.addGate(p -> p == gatedMessage);
        builderA.install();
        Assert.assertEquals((long)3L, (long)this.getHandlers(this.channel.pipeline()).size());
        Assert.assertThat((Object)this.channel.pipeline().names(), (Matcher)Matchers.hasItems((Object[])new String[]{"error_handler_head", "message_gate", "error_handler_tail"}));
        ServerNettyPipelineBuilder builderB = NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log);
        builderB.add("my_handler", new ChannelHandler[]{this.EMPTY_HANDLER});
        builderB.install();
        Assert.assertEquals((long)4L, (long)this.getHandlers(this.channel.pipeline()).size());
        Assert.assertThat((Object)this.channel.pipeline().names(), (Matcher)Matchers.hasItems((Object[])new String[]{"error_handler_head", "my_handler", "message_gate", "error_handler_tail"}));
    }

    @Test
    public void shouldInvokeCloseHandlerOnClose() throws InterruptedException {
        Semaphore semaphore = new Semaphore(0);
        ((ServerNettyPipelineBuilder)NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).onClose(semaphore::release)).install();
        this.channel.close();
        Assert.assertTrue((boolean)semaphore.tryAcquire(1L, TimeUnit.MINUTES));
        Assert.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    public void shouldInvokeCloseHandlerOnPeerDisconnect() throws InterruptedException {
        Semaphore semaphore = new Semaphore(0);
        ((ServerNettyPipelineBuilder)NettyPipelineBuilder.server((ChannelPipeline)this.channel.pipeline(), (Log)this.log).onClose(semaphore::release)).install();
        this.channel.disconnect();
        Assert.assertTrue((boolean)semaphore.tryAcquire(1L, TimeUnit.MINUTES));
        Assert.assertFalse((boolean)this.channel.isOpen());
    }

    private List<ChannelHandler> getHandlers(ChannelPipeline pipeline) {
        return pipeline.names().stream().map(arg_0 -> ((ChannelPipeline)pipeline).get(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

