/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

public class ClusterLeaderStepDownIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(8).withNumberOfReadReplicas(0);

    @Test
    public void leaderShouldStepDownWhenFollowersAreGone() throws Throwable {
        Cluster cluster = this.clusterRule.startCluster();
        CoreClusterMember leader = cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"bam")});
            node.setProperty("bam", (Object)"bam");
            tx.success();
        });
        ThrowingSupplier followers = () -> cluster.coreMembers().stream().filter(m -> m.raft().currentRole() != Role.LEADER).collect(Collectors.toList());
        Assert.assertEventually((String)"All followers visible", (ThrowingSupplier)followers, (Matcher)Matchers.hasSize((int)7), (long)2L, (TimeUnit)TimeUnit.MINUTES);
        ((List)followers.get()).subList(0, 4).forEach(CoreClusterMember::shutdown);
        Assert.assertEventually((String)"Leader should have stepped down.", () -> leader.raft().isLeader(), (Matcher)Matchers.is((Object)false), (long)2L, (TimeUnit)TimeUnit.MINUTES);
    }
}

