/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

public class InstalledProtocolsProcedureIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withSharedCoreParam(CausalClusteringSettings.leader_election_timeout, "2s").withSharedCoreParam(CausalClusteringSettings.compression_implementations, "snappy").withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    private Cluster cluster;
    private CoreClusterMember leader;

    @Before
    public void startUp() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        this.leader = this.cluster.awaitLeader();
    }

    @Test
    public void shouldSeeOutboundInstalledProtocolsOnLeader() throws Throwable {
        String modifiers = new StringJoiner(",", "[", "]").add(Protocol.ModifierProtocols.COMPRESSION_SNAPPY.implementation()).toString();
        Object[] expectedProtocolInfos = (ProtocolInfo[])this.cluster.coreMembers().stream().filter(member -> !member.equals(this.leader)).map(member -> new ProtocolInfo("outbound", this.localhost(member.raftListenAddress()), Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), 1L, modifiers)).toArray(ProtocolInfo[]::new);
        Assert.assertEventually((String)("should see outbound installed protocols on core " + this.leader.serverId()), () -> this.installedProtocols((GraphDatabaseFacade)this.leader.database(), "outbound"), (Matcher)Matchers.hasItems((Object[])expectedProtocolInfos), (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldSeeInboundInstalledProtocolsOnLeader() throws Throwable {
        Assert.assertEventually((String)("should see inbound installed protocols on core " + this.leader.serverId()), () -> this.installedProtocols((GraphDatabaseFacade)this.leader.database(), "inbound"), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(this.cluster.coreMembers().size() - 1))), (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    /*
     * Exception decompiling
     */
    private List<ProtocolInfo> installedProtocols(GraphDatabaseFacade db, String wantedOrientation) throws TransactionFailureException, ProcedureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String localhost(String uri) {
        return uri.replace("127.0.0.1", "localhost");
    }

    private static class ProtocolInfo {
        private final String orientation;
        private final String address;
        private final String protocol;
        private final long version;
        private final String modifiers;

        private ProtocolInfo(String orientation, String address, String protocol, long version, String modifiers) {
            this.orientation = orientation;
            this.address = address;
            this.protocol = protocol;
            this.version = version;
            this.modifiers = modifiers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProtocolInfo that = (ProtocolInfo)o;
            return this.version == that.version && Objects.equals(this.orientation, that.orientation) && Objects.equals(this.address, that.address) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.modifiers, that.modifiers);
        }

        public int hashCode() {
            return Objects.hash(this.orientation, this.address, this.protocol, this.version, this.modifiers);
        }

        public String toString() {
            return "ProtocolInfo{orientation='" + this.orientation + '\'' + ", address='" + this.address + '\'' + ", protocol='" + this.protocol + '\'' + ", version=" + this.version + ", modifiers='" + this.modifiers + '\'' + '}';
        }
    }
}

