/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.catchup.CatchUpResponseHandler;
import org.neo4j.causalclustering.catchup.CatchupClientProtocol;
import org.neo4j.causalclustering.catchup.ClientMessageTypeHandler;
import org.neo4j.causalclustering.catchup.RequestDecoderDispatcher;
import org.neo4j.causalclustering.catchup.RequestMessageTypeEncoder;
import org.neo4j.causalclustering.catchup.ResponseMessageTypeEncoder;
import org.neo4j.causalclustering.catchup.StoreListingResponseHandler;
import org.neo4j.causalclustering.catchup.storecopy.FileChunkDecoder;
import org.neo4j.causalclustering.catchup.storecopy.FileChunkHandler;
import org.neo4j.causalclustering.catchup.storecopy.FileHeaderDecoder;
import org.neo4j.causalclustering.catchup.storecopy.FileHeaderHandler;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdRequestEncoder;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponseDecoder;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponseHandler;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequestEncoder;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponseDecoder;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponseHandler;
import org.neo4j.causalclustering.catchup.tx.TxPullRequestEncoder;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseDecoder;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseHandler;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponseDecoder;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponseHandler;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotDecoder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotRequestEncoder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotResponseHandler;
import org.neo4j.causalclustering.protocol.ClientNettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CatchupProtocolClientInstaller
implements ProtocolInstaller<ProtocolInstaller.Orientation.Client> {
    private static final Protocol.ApplicationProtocols APPLICATION_PROTOCOL = Protocol.ApplicationProtocols.CATCHUP_1;
    private final List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>> modifiers;
    private final LogProvider logProvider;
    private final Log log;
    private final NettyPipelineBuilderFactory pipelineBuilder;
    private final CatchUpResponseHandler handler;

    public CatchupProtocolClientInstaller(NettyPipelineBuilderFactory pipelineBuilder, List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>> modifiers, LogProvider logProvider, CatchUpResponseHandler handler) {
        this.modifiers = modifiers;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.pipelineBuilder = pipelineBuilder;
        this.handler = handler;
    }

    @Override
    public void install(Channel channel) throws Exception {
        CatchupClientProtocol protocol = new CatchupClientProtocol();
        RequestDecoderDispatcher<CatchupClientProtocol.State> decoderDispatcher = new RequestDecoderDispatcher<CatchupClientProtocol.State>(protocol, this.logProvider);
        decoderDispatcher.register(CatchupClientProtocol.State.STORE_ID, (ChannelInboundHandler)new GetStoreIdResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.TX_PULL_RESPONSE, (ChannelInboundHandler)new TxPullResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.CORE_SNAPSHOT, (ChannelInboundHandler)new CoreSnapshotDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.STORE_COPY_FINISHED, (ChannelInboundHandler)new StoreCopyFinishedResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.TX_STREAM_FINISHED, (ChannelInboundHandler)new TxStreamFinishedResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.FILE_HEADER, (ChannelInboundHandler)new FileHeaderDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.PREPARE_STORE_COPY_RESPONSE, (ChannelInboundHandler)new PrepareStoreCopyResponse.Decoder());
        decoderDispatcher.register(CatchupClientProtocol.State.FILE_CONTENTS, (ChannelInboundHandler)new FileChunkDecoder());
        ((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)((ClientNettyPipelineBuilder)this.pipelineBuilder.client(channel, this.log).modify(this.modifiers)).addFraming().add("enc_req_tx", new ChannelHandler[]{new TxPullRequestEncoder()})).add("enc_req_index", new ChannelHandler[]{new GetIndexFilesRequest.Encoder()})).add("enc_req_store", new ChannelHandler[]{new GetStoreFileRequest.Encoder()})).add("enc_req_snapshot", new ChannelHandler[]{new CoreSnapshotRequestEncoder()})).add("enc_req_store_id", new ChannelHandler[]{new GetStoreIdRequestEncoder()})).add("enc_req_type", new ChannelHandler[]{new ResponseMessageTypeEncoder()})).add("enc_res_type", new ChannelHandler[]{new RequestMessageTypeEncoder()})).add("enc_req_precopy", new ChannelHandler[]{new PrepareStoreCopyRequestEncoder()})).add("in_res_type", new ChannelHandler[]{new ClientMessageTypeHandler(protocol, this.logProvider)})).add("dec_dispatch", new ChannelHandler[]{decoderDispatcher})).add("hnd_res_tx", new ChannelHandler[]{new TxPullResponseHandler(protocol, this.handler)})).add("hnd_res_snapshot", new ChannelHandler[]{new CoreSnapshotResponseHandler(protocol, this.handler)})).add("hnd_res_copy_fin", new ChannelHandler[]{new StoreCopyFinishedResponseHandler(protocol, this.handler)})).add("hnd_res_tx_fin", new ChannelHandler[]{new TxStreamFinishedResponseHandler(protocol, this.handler)})).add("hnd_res_file_header", new ChannelHandler[]{new FileHeaderHandler(protocol, this.handler, this.logProvider)})).add("hnd_res_file_chunk", new ChannelHandler[]{new FileChunkHandler(protocol, this.handler)})).add("hnd_res_store_id", new ChannelHandler[]{new GetStoreIdResponseHandler(protocol, this.handler)})).add("hnd_res_store_listing", new ChannelHandler[]{new StoreListingResponseHandler(protocol, this.handler)})).onClose(this.handler::onClose)).install();
    }

    @Override
    public Protocol.ApplicationProtocol applicationProtocol() {
        return APPLICATION_PROTOCOL;
    }

    @Override
    public Collection<Collection<Protocol.ModifierProtocol>> modifiers() {
        return this.modifiers.stream().map(ModifierProtocolInstaller::protocols).collect(Collectors.toList());
    }

    public static class Factory
    extends ProtocolInstaller.Factory<ProtocolInstaller.Orientation.Client, CatchupProtocolClientInstaller> {
        public Factory(NettyPipelineBuilderFactory pipelineBuilder, LogProvider logProvider, CatchUpResponseHandler handler) {
            super(APPLICATION_PROTOCOL, modifiers -> new CatchupProtocolClientInstaller(pipelineBuilder, (List<ModifierProtocolInstaller<ProtocolInstaller.Orientation.Client>>)modifiers, logProvider, handler));
        }
    }
}

