/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStream;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamProvider;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDisk;
import org.neo4j.causalclustering.catchup.tx.FileCopyMonitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.monitoring.Monitors;

public class StreamToDiskProvider
implements StoreFileStreamProvider {
    private final File storeDir;
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final FileCopyMonitor fileCopyMonitor;

    StreamToDiskProvider(File storeDir, FileSystemAbstraction fs, PageCache pageCache, Monitors monitors) {
        this.storeDir = storeDir;
        this.fs = fs;
        this.pageCache = pageCache;
        this.fileCopyMonitor = (FileCopyMonitor)monitors.newMonitor(FileCopyMonitor.class, new String[0]);
    }

    @Override
    public StoreFileStream acquire(String destination, int requiredAlignment) throws IOException {
        File fileName = new File(this.storeDir, destination);
        this.fs.mkdirs(fileName.getParentFile());
        this.fileCopyMonitor.copyFile(fileName);
        if (!this.pageCache.fileSystemSupportsFileOperations() && StoreType.canBeManagedByPageCache((String)destination)) {
            int filePageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % requiredAlignment;
            PagedFile pagedFile = this.pageCache.map(fileName, filePageSize, new OpenOption[]{StandardOpenOption.CREATE});
            return StreamToDisk.fromPagedFile(pagedFile);
        }
        return StreamToDisk.fromFile(this.fs, fileName);
    }
}

