/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication.monitoring;

import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.monitoring.ReplicationMonitor;
import org.neo4j.logging.Log;

public class LoggingReplicationMonitor
implements ReplicationMonitor {
    private final Log log;
    private int attempts;
    private ReplicatedContent current;

    public LoggingReplicationMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void startReplication(ReplicatedContent command) {
        this.clear(command);
    }

    @Override
    public void replicationAttempt() {
        if (this.attempts > 0) {
            this.log.warn("Failed to replicate content. Attempt %d, Content: %s", new Object[]{this.attempts, this.current});
        }
        ++this.attempts;
    }

    @Override
    public void successfulReplication() {
        this.clear(null);
    }

    @Override
    public void failedReplication(Throwable t) {
        this.clear(null);
        this.log.error("Failed to replicate content", t);
    }

    private void clear(ReplicatedContent o) {
        this.current = o;
        this.attempts = 0;
    }
}

