/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import org.neo4j.causalclustering.discovery.DomainNameResolver;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.UnknownHostException;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class DnsHostnameResolver
implements HostnameResolver {
    private final Log userLog;
    private final Log log;
    private final DomainNameResolver domainNameResolver;

    public DnsHostnameResolver(LogProvider logProvider, LogProvider userLogProvider, DomainNameResolver domainNameResolver) {
        this.log = logProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
        this.domainNameResolver = domainNameResolver;
    }

    @Override
    public Collection<AdvertisedSocketAddress> resolve(AdvertisedSocketAddress initialAddress) {
        HashSet<AdvertisedSocketAddress> addresses = new HashSet<AdvertisedSocketAddress>();
        InetAddress[] ipAddresses = new InetAddress[]{};
        try {
            ipAddresses = this.domainNameResolver.resolveDomainName(initialAddress.getHostname());
        }
        catch (UnknownHostException e) {
            this.log.error(String.format("Failed to resolve host '%s'", initialAddress.getHostname()), (Throwable)e);
        }
        for (InetAddress ipAddress : ipAddresses) {
            addresses.add(new AdvertisedSocketAddress(ipAddress.getHostAddress(), initialAddress.getPort()));
        }
        this.userLog.info("Resolved initial host '%s' to %s", new Object[]{initialAddress, addresses});
        return addresses;
    }
}

