/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;

public class ProtocolInstallerRepository<O extends ProtocolInstaller.Orientation> {
    private final Map<Protocol.ApplicationProtocol, ProtocolInstaller.Factory<O, ?>> installers;
    private final Map<Protocol.ModifierProtocol, ModifierProtocolInstaller<O>> modifiers;

    public ProtocolInstallerRepository(Collection<ProtocolInstaller.Factory<O, ?>> installers, Collection<ModifierProtocolInstaller<O>> modifiers) {
        HashMap tempInstallers = new HashMap();
        installers.forEach(installer -> this.addTo(tempInstallers, installer, installer.applicationProtocol()));
        this.installers = Collections.unmodifiableMap(tempInstallers);
        HashMap tempModifierInstallers = new HashMap();
        modifiers.forEach(installer -> installer.protocols().forEach(protocol -> this.addTo(tempModifierInstallers, installer, protocol)));
        this.modifiers = Collections.unmodifiableMap(tempModifierInstallers);
    }

    private <T, P extends Protocol> void addTo(Map<P, T> tempServerMap, T installer, P protocol) {
        T old = tempServerMap.put(protocol, installer);
        if (old != null) {
            throw new IllegalArgumentException(String.format("Duplicate protocol installers for protocol %s: %s and %s", protocol, installer, old));
        }
    }

    public ProtocolInstaller<O> installerFor(ProtocolStack protocolStack) {
        Protocol.ApplicationProtocol applicationProtocol = protocolStack.applicationProtocol();
        ProtocolInstaller.Factory<O, ?> protocolInstaller = this.installers.get(applicationProtocol);
        this.ensureKnownProtocol(applicationProtocol, protocolInstaller);
        return protocolInstaller.create(this.getModifierProtocolInstallers(protocolStack));
    }

    private List<ModifierProtocolInstaller<O>> getModifierProtocolInstallers(ProtocolStack protocolStack) {
        ArrayList<ModifierProtocolInstaller<O>> modifierProtocolInstallers = new ArrayList<ModifierProtocolInstaller<O>>();
        for (Protocol.ModifierProtocol modifierProtocol : protocolStack.modifierProtocols()) {
            this.ensureNotDuplicate(modifierProtocolInstallers, modifierProtocol);
            ModifierProtocolInstaller<O> protocolInstaller = this.modifiers.get(modifierProtocol);
            this.ensureKnownProtocol(modifierProtocol, protocolInstaller);
            modifierProtocolInstallers.add(protocolInstaller);
        }
        return modifierProtocolInstallers;
    }

    private void ensureNotDuplicate(List<ModifierProtocolInstaller<O>> modifierProtocolInstallers, Protocol.ModifierProtocol modifierProtocol) {
        boolean duplicateIdentifier = modifierProtocolInstallers.stream().flatMap(modifier -> modifier.protocols().stream()).anyMatch(protocol -> protocol.category().equals(modifierProtocol.category()));
        if (duplicateIdentifier) {
            throw new IllegalArgumentException("Attempted to install multiple versions of " + modifierProtocol.category());
        }
    }

    private void ensureKnownProtocol(Protocol protocol, Object protocolInstaller) {
        if (protocolInstaller == null) {
            throw new IllegalStateException(String.format("Installer for requested protocol %s does not exist", protocol));
        }
    }
}

