/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.multi_cluster.procedure;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.Role;
import org.neo4j.causalclustering.routing.multi_cluster.MultiClusterRoutingResult;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.ParameterNames;
import org.neo4j.causalclustering.routing.procedure.RoutingResultFormatHelper;

public class MultiClusterRoutingResultFormat {
    private static final String DB_NAME_KEY = "database";
    private static final String ADDRESSES_KEY = "addresses";

    private MultiClusterRoutingResultFormat() {
    }

    static Object[] build(MultiClusterRoutingResult result) {
        Function<List, Object[]> stringifyAddresses = es -> es.stream().map(e -> e.address().toString()).toArray();
        List response = result.routers().entrySet().stream().map(entry -> {
            String dbName = (String)entry.getKey();
            Object[] addresses = (Object[])stringifyAddresses.apply((List)entry.getValue());
            TreeMap<String, Object> responseRow = new TreeMap<String, Object>();
            responseRow.put(DB_NAME_KEY, dbName);
            responseRow.put(ADDRESSES_KEY, addresses);
            return responseRow;
        }).collect(Collectors.toList());
        long ttlSeconds = TimeUnit.MILLISECONDS.toSeconds(result.ttlMillis());
        return new Object[]{ttlSeconds, response};
    }

    public static MultiClusterRoutingResult parse(Map<String, Object> record) {
        return MultiClusterRoutingResultFormat.parse(new Object[]{record.get(ParameterNames.TTL.parameterName()), record.get(ParameterNames.ROUTERS.parameterName())});
    }

    public static MultiClusterRoutingResult parse(Object[] record) {
        long ttlSeconds = (Long)record[0];
        List rows = (List)record[1];
        Map<String, List<Endpoint>> routers = MultiClusterRoutingResultFormat.parseRouters(rows);
        return new MultiClusterRoutingResult(routers, ttlSeconds * 1000L);
    }

    private static Map<String, List<Endpoint>> parseRouters(List<Map<String, Object>> responseRows) {
        Function<Map, String> dbNameFromRow = row -> (String)row.get(DB_NAME_KEY);
        Function<Map, List> endpointsFromRow = row -> RoutingResultFormatHelper.parseEndpoints((Object[])row.get(ADDRESSES_KEY), Role.ROUTE);
        return responseRows.stream().collect(Collectors.toMap(dbNameFromRow, endpointsFromRow));
    }
}

