/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.com.ChannelCloser;
import org.neo4j.com.IdleChannelReaper;
import org.neo4j.com.RequestContext;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class IdleChannelReaperTest {
    private static final int THRESHOLD = 100;
    private static final NullLogProvider NO_LOGGING = NullLogProvider.getInstance();

    @Test
    public void shouldNotCloseAnyRecentlyActiveChannels() {
        FakeClock clock = Clocks.fakeClock();
        ChannelCloser channelCloser = (ChannelCloser)Mockito.mock(ChannelCloser.class);
        IdleChannelReaper idleChannelReaper = new IdleChannelReaper(channelCloser, (LogProvider)NO_LOGGING, (Clock)clock, 100L);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        idleChannelReaper.add(channel, this.dummyRequestContext());
        idleChannelReaper.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channelCloser});
    }

    @Test
    public void shouldCloseAnyChannelsThatHaveBeenIdleForLongerThanThreshold() {
        FakeClock clock = Clocks.fakeClock();
        ChannelCloser channelCloser = (ChannelCloser)Mockito.mock(ChannelCloser.class);
        IdleChannelReaper idleChannelReaper = new IdleChannelReaper(channelCloser, (LogProvider)NO_LOGGING, (Clock)clock, 100L);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        idleChannelReaper.add(channel, this.dummyRequestContext());
        clock.forward(101L, TimeUnit.MILLISECONDS);
        idleChannelReaper.run();
        ((ChannelCloser)Mockito.verify((Object)channelCloser)).tryToCloseChannel(channel);
    }

    @Test
    public void shouldNotCloseAChannelThatHasBeenIdleForMoreThanHalfThresholdButIsStillOpenConnectedAndBound() {
        FakeClock clock = Clocks.fakeClock();
        ChannelCloser channelCloser = (ChannelCloser)Mockito.mock(ChannelCloser.class);
        IdleChannelReaper idleChannelReaper = new IdleChannelReaper(channelCloser, (LogProvider)NO_LOGGING, (Clock)clock, 100L);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        idleChannelReaper.add(channel, this.dummyRequestContext());
        Mockito.when((Object)channel.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)channel.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)channel.isBound()).thenReturn((Object)true);
        clock.forward(60L, TimeUnit.MILLISECONDS);
        idleChannelReaper.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channelCloser});
    }

    @Test
    public void shouldNotTryToCloseAChannelThatHasBeenRemoved() {
        FakeClock clock = Clocks.fakeClock();
        ChannelCloser channelCloser = (ChannelCloser)Mockito.mock(ChannelCloser.class);
        IdleChannelReaper idleChannelReaper = new IdleChannelReaper(channelCloser, (LogProvider)NO_LOGGING, (Clock)clock, 100L);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        RequestContext request = this.dummyRequestContext();
        idleChannelReaper.add(channel, request);
        idleChannelReaper.remove(channel);
        clock.forward(101L, TimeUnit.MILLISECONDS);
        idleChannelReaper.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channelCloser});
    }

    @Test
    public void shouldNotTryToCloseAChannelThatWasRecentlyActive() {
        FakeClock clock = Clocks.fakeClock();
        ChannelCloser channelCloser = (ChannelCloser)Mockito.mock(ChannelCloser.class);
        IdleChannelReaper idleChannelReaper = new IdleChannelReaper(channelCloser, (LogProvider)NO_LOGGING, (Clock)clock, 100L);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        RequestContext request = this.dummyRequestContext();
        idleChannelReaper.add(channel, request);
        clock.forward(200L, TimeUnit.MILLISECONDS);
        idleChannelReaper.update(channel);
        idleChannelReaper.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channelCloser});
    }

    private RequestContext dummyRequestContext() {
        return new RequestContext(1L, 1, 1, 1L, 1L);
    }
}

