/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.StoreIdTestFactory;
import org.neo4j.com.storecopy.ResponsePacker;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;

public class ResponsePackerTest {
    @Test
    public void shouldHaveFixedTargetTransactionIdEvenIfLastTransactionIdIsMoving() throws Exception {
        LogicalTransactionStore transactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        long lastAppliedTransactionId = 5L;
        EndlessCursor endlessCursor = new EndlessCursor(lastAppliedTransactionId + 1L);
        Mockito.when((Object)transactionStore.getTransactions(ArgumentMatchers.anyLong())).thenReturn((Object)endlessCursor);
        long targetTransactionId = 8L;
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore(8L, 0L, 0L, 0L, 0L);
        ResponsePacker packer = new ResponsePacker(transactionStore, (TransactionIdStore)transactionIdStore, Suppliers.singleton((Object)StoreIdTestFactory.newStoreIdForCurrentVersion()));
        Response response = packer.packTransactionStreamResponse(this.requestContextStartingAt(5L), null);
        final AtomicLong nextExpectedVisit = new AtomicLong(lastAppliedTransactionId);
        response.accept(new Response.Handler((TransactionIdStore)transactionIdStore){
            final /* synthetic */ TransactionIdStore val$transactionIdStore;
            {
                this.val$transactionIdStore = transactionIdStore;
            }

            public void obligation(long txId) {
                Assert.fail((String)"Should not be called");
            }

            public Visitor<CommittedTransactionRepresentation, Exception> transactions() {
                return element -> {
                    long txId = element.getCommitEntry().getTxId();
                    Assert.assertThat((Object)txId, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(8L)));
                    Assert.assertEquals((long)nextExpectedVisit.incrementAndGet(), (long)txId);
                    this.val$transactionIdStore.setLastCommittedAndClosedTransactionId(this.val$transactionIdStore.getLastCommittedTransactionId() + 1L, 0L, 0L, 3L, 4L);
                    return true;
                };
            }
        });
    }

    private RequestContext requestContextStartingAt(long txId) {
        return new RequestContext(0L, 0, 0, txId, 0L);
    }

    public class EndlessCursor
    implements TransactionCursor {
        private final LogPosition position = new LogPosition(0L, 0L);
        private long txId;
        private CommittedTransactionRepresentation transaction;

        public EndlessCursor(long txId) {
            this.txId = txId;
        }

        public void close() {
        }

        public CommittedTransactionRepresentation get() {
            return this.transaction;
        }

        public boolean next() {
            this.transaction = new CommittedTransactionRepresentation(null, null, new LogEntryCommit(this.txId++, 0L));
            return true;
        }

        public LogPosition position() {
            return this.position;
        }
    }
}

