/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.IOException;
import org.neo4j.com.ComException;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.logging.Log;

class BatchingResponseHandler
implements Response.Handler,
Visitor<CommittedTransactionRepresentation, Exception> {
    private final TransactionQueue queue;
    private final ResponseUnpacker.TxHandler txHandler;
    private final VersionContextSupplier versionContextSupplier;
    private final TransactionObligationFulfiller obligationFulfiller;
    private final Log log;

    BatchingResponseHandler(int maxBatchSize, TransactionQueue.Applier applier, TransactionObligationFulfiller obligationFulfiller, ResponseUnpacker.TxHandler txHandler, VersionContextSupplier versionContextSupplier, Log log) {
        this.obligationFulfiller = obligationFulfiller;
        this.txHandler = txHandler;
        this.versionContextSupplier = versionContextSupplier;
        this.queue = new TransactionQueue(maxBatchSize, applier);
        this.log = log;
    }

    @Override
    public void obligation(long txId) throws IOException {
        if (txId == 1L) {
            return;
        }
        try {
            this.obligationFulfiller.fulfill(txId);
        }
        catch (IllegalStateException e) {
            throw new ComException("Failed to pull updates", e).traceComException(this.log, "BatchingResponseHandler.obligation");
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Visitor<CommittedTransactionRepresentation, Exception> transactions() {
        return this;
    }

    public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
        this.queue.queue(new TransactionToApply(transaction.getTransactionRepresentation(), transaction.getCommitEntry().getTxId(), this.versionContextSupplier.getVersionContext()){

            public void commitment(Commitment commitment, long transactionId) {
                super.commitment(commitment, transactionId);
                BatchingResponseHandler.this.txHandler.accept(transactionId);
            }
        });
        return false;
    }

    void applyQueuedTransactions() throws Exception {
        this.queue.empty();
    }
}

