/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Optional;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ServerFailureException;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class StoreCopyServer {
    private final NeoStoreDataSource dataSource;
    private final CheckPointer checkPointer;
    private final FileSystemAbstraction fileSystem;
    private final File storeDirectory;
    private final Monitor monitor;
    private final PageCache pageCache;
    private final StoreCopyCheckPointMutex mutex;

    public StoreCopyServer(NeoStoreDataSource dataSource, CheckPointer checkPointer, FileSystemAbstraction fileSystem, File storeDirectory, Monitor monitor, PageCache pageCache, StoreCopyCheckPointMutex mutex) {
        this.dataSource = dataSource;
        this.checkPointer = checkPointer;
        this.fileSystem = fileSystem;
        this.mutex = mutex;
        this.storeDirectory = FileUtils.getMostCanonicalFile((File)storeDirectory);
        this.monitor = monitor;
        this.pageCache = pageCache;
    }

    public Monitor monitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestContext flushStoresAndStreamStoreFiles(String triggerName, StoreWriter writer, boolean includeLogs) {
        try {
            long lastAppliedTransaction;
            String storeCopyIdentifier = Thread.currentThread().getName();
            ThrowingAction checkPointAction = () -> {
                this.monitor.startTryCheckPoint(storeCopyIdentifier);
                this.checkPointer.tryCheckPoint((TriggerInfo)new SimpleTriggerInfo(triggerName));
                this.monitor.finishTryCheckPoint(storeCopyIdentifier);
            };
            try (Resource lock = this.mutex.storeCopy(checkPointAction);
                 ResourceIterator files = this.dataSource.listStoreFiles(includeLogs);){
                lastAppliedTransaction = this.checkPointer.lastCheckPointedTransactionId();
                this.monitor.startStreamingStoreFiles(storeCopyIdentifier);
                ByteBuffer temporaryBuffer = ByteBuffer.allocateDirect((int)ByteUnit.mebiBytes((long)1L));
                while (files.hasNext()) {
                    Optional optionalPagedFile;
                    StoreFileMetadata meta = (StoreFileMetadata)files.next();
                    File file = meta.file();
                    boolean isLogFile = meta.isLogFile();
                    int recordSize = meta.recordSize();
                    if (!this.pageCache.fileSystemSupportsFileOperations() && (optionalPagedFile = this.pageCache.getExistingMapping(file)).isPresent()) {
                        PagedFile pagedFile = (PagedFile)optionalPagedFile.get();
                        Throwable throwable = null;
                        try {
                            long fileSize = pagedFile.fileSize();
                            ReadableByteChannel fileChannel = pagedFile.openReadableByteChannel();
                            Throwable throwable2 = null;
                            try {
                                this.doWrite(writer, temporaryBuffer, file, recordSize, fileChannel, fileSize, storeCopyIdentifier, false);
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (fileChannel == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        fileChannel.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                fileChannel.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (pagedFile == null) continue;
                            if (throwable != null) {
                                try {
                                    pagedFile.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            pagedFile.close();
                            continue;
                        }
                    }
                    StoreChannel fileChannel = this.fileSystem.open(file, OpenMode.READ);
                    Throwable throwable = null;
                    try {
                        long fileSize = this.fileSystem.getFileSize(file);
                        this.doWrite(writer, temporaryBuffer, file, recordSize, (ReadableByteChannel)fileChannel, fileSize, storeCopyIdentifier, isLogFile);
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (fileChannel == null) continue;
                        if (throwable != null) {
                            try {
                                fileChannel.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        fileChannel.close();
                    }
                }
            }
            finally {
                this.monitor.finishStreamingStoreFiles(storeCopyIdentifier);
            }
            return RequestContext.anonymous(lastAppliedTransaction);
        }
        catch (IOException e) {
            throw new ServerFailureException(e);
        }
    }

    private void doWrite(StoreWriter writer, ByteBuffer temporaryBuffer, File file, int recordSize, ReadableByteChannel fileChannel, long fileSize, String storeCopyIdentifier, boolean isLogFile) throws IOException {
        this.monitor.startStreamingStoreFile(file, storeCopyIdentifier);
        String path = isLogFile ? file.getName() : FileUtils.relativePath((File)this.storeDirectory, (File)file);
        writer.write(path, fileChannel, temporaryBuffer, fileSize > 0L, recordSize);
        this.monitor.finishStreamingStoreFile(file, storeCopyIdentifier);
    }

    public static interface Monitor {
        public void startTryCheckPoint(String var1);

        public void finishTryCheckPoint(String var1);

        public void startStreamingStoreFile(File var1, String var2);

        public void finishStreamingStoreFile(File var1, String var2);

        public void startStreamingStoreFiles(String var1);

        public void finishStreamingStoreFiles(String var1);

        public void startStreamingTransactions(long var1, String var3);

        public void finishStreamingTransactions(long var1, String var3);

        public static class Adapter
        implements Monitor {
            @Override
            public void startTryCheckPoint(String storeCopyIdentifier) {
            }

            @Override
            public void finishTryCheckPoint(String storeCopyIdentifier) {
            }

            @Override
            public void startStreamingStoreFile(File file, String storeCopyIdentifier) {
            }

            @Override
            public void finishStreamingStoreFile(File file, String storeCopyIdentifier) {
            }

            @Override
            public void startStreamingStoreFiles(String storeCopyIdentifier) {
            }

            @Override
            public void finishStreamingStoreFiles(String storeCopyIdentifier) {
            }

            @Override
            public void startStreamingTransactions(long startTxId, String storeCopyIdentifier) {
            }

            @Override
            public void finishStreamingTransactions(long endTxId, String storeCopyIdentifier) {
            }
        }
    }
}

