/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.TextUtil;

public class TextUtilTest {
    @Test
    public void shouldReplaceVariablesWithValuesInTemplateString() {
        String template = "This is a $FIRST that $SECOND $THIRD!";
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("FIRST", "String");
        values.put("SECOND", "should");
        values.put("THIRD", "act as a template!");
        String string = TextUtil.templateString((String)template, values);
        Assert.assertEquals((Object)"This is a String that should act as a template!!", (Object)string);
    }

    @Test
    public void shouldTokenizeStringWithWithoutQuotes() {
        String untokenized = "First Second Third";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized);
        Assert.assertArrayEquals((Object[])new String[]{"First", "Second", "Third"}, (Object[])tokenized);
    }

    @Test
    public void shouldTokenizeStringWithQuotes() {
        String untokenized = "First \"Second one\" Third \"And a fourth\"";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized);
        Assert.assertArrayEquals((Object[])new String[]{"First", "Second one", "Third", "And a fourth"}, (Object[])tokenized);
    }

    @Test
    public void shouldTokenStringWithWithQuotesAndEscapedSpaces() {
        String untokenized = "First \"Second one\" Third And\\ a\\ fourth";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized);
        Assert.assertArrayEquals((Object[])new String[]{"First", "Second one", "Third", "And a fourth"}, (Object[])tokenized);
    }

    @Test
    public void shouldPreserveBackslashes() {
        String untokenized = "First C:\\a\\b\\c";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized, (boolean)true, (boolean)true);
        Assert.assertArrayEquals((Object[])new String[]{"First", "C:\\a\\b\\c"}, (Object[])tokenized);
    }
}

