/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ports.allocation;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.ports.allocation.PortRepository;

public class PortRepositoryIT {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void shouldReservePorts() throws Exception {
        PortRepository portRepository1 = new PortRepository(this.temporaryDirectory(), 49152);
        int port1 = portRepository1.reserveNextPort("foo");
        int port2 = portRepository1.reserveNextPort("foo");
        int port3 = portRepository1.reserveNextPort("foo");
        Assert.assertThat((Object)new HashSet<Integer>(Arrays.asList(port1, port2, port3)).size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void shouldCoordinateUsingFileSystem() throws Exception {
        Path temporaryDirectory = this.temporaryDirectory();
        PortRepository portRepository1 = new PortRepository(temporaryDirectory, 49152);
        PortRepository portRepository2 = new PortRepository(temporaryDirectory, 49152);
        int port1 = portRepository1.reserveNextPort("foo");
        int port2 = portRepository1.reserveNextPort("foo");
        int port3 = portRepository1.reserveNextPort("foo");
        int port4 = portRepository2.reserveNextPort("foo");
        int port5 = portRepository2.reserveNextPort("foo");
        int port6 = portRepository1.reserveNextPort("foo");
        Assert.assertThat((Object)new HashSet<Integer>(Arrays.asList(port1, port2, port3, port4, port5, port6)).size(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    @Ignore
    public void shouldNotInterfereWithOtherRepositories() throws Exception {
        PortRepository portRepository1 = new PortRepository(this.temporaryDirectory(), 49152);
        PortRepository portRepository2 = new PortRepository(this.temporaryDirectory(), 49152);
        int port1 = portRepository1.reserveNextPort("foo");
        int port2 = portRepository1.reserveNextPort("foo");
        int port3 = portRepository1.reserveNextPort("foo");
        int port4 = portRepository2.reserveNextPort("foo");
        int port5 = portRepository2.reserveNextPort("foo");
        int port6 = portRepository1.reserveNextPort("foo");
        Assert.assertThat((Object)new HashSet<Integer>(Arrays.asList(port1, port2, port3, port4, port5, port6)).size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void shouldNotOverrun() throws Exception {
        PortRepository portRepository1 = new PortRepository(this.temporaryDirectory(), 65534);
        portRepository1.reserveNextPort("foo");
        portRepository1.reserveNextPort("foo");
        try {
            portRepository1.reserveNextPort("foo");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"There are no more ports available"));
        }
    }

    private Path temporaryDirectory() throws IOException {
        return this.temporaryFolder.newFolder("port-repository").toPath();
    }
}

