/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ports.allocation;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.ports.allocation.PortProbe;
import org.neo4j.ports.allocation.SimplePortProvider;

public class SimplePortProviderTest {
    @Test
    public void shouldProvideUniquePorts() {
        SimplePortProvider portProvider = new SimplePortProvider(port -> false, 42);
        int port1 = portProvider.getNextFreePort("foo");
        int port2 = portProvider.getNextFreePort("foo");
        Assert.assertThat((Object)port1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)port2))));
    }

    @Test
    public void shouldSkipOccupiedPorts() {
        PortProbe portProbe = (PortProbe)Mockito.mock(PortProbe.class);
        SimplePortProvider portProvider = new SimplePortProvider(portProbe, 40);
        Mockito.when((Object)portProbe.isOccupied(40)).thenReturn((Object)false);
        Mockito.when((Object)portProbe.isOccupied(41)).thenReturn((Object)false);
        Mockito.when((Object)portProbe.isOccupied(42)).thenReturn((Object)true);
        Mockito.when((Object)portProbe.isOccupied(43)).thenReturn((Object)false);
        Assert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)40));
        Assert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)41));
        Assert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)43));
    }

    @Test
    public void shouldNotOverRun() {
        SimplePortProvider portProvider = new SimplePortProvider(port -> false, 65534);
        portProvider.getNextFreePort("foo");
        portProvider.getNextFreePort("foo");
        try {
            portProvider.getNextFreePort("foo");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"There are no more ports available"));
        }
    }
}

