/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.junit.Test;
import org.neo4j.util.Preconditions;

public class PreconditionsTest {
    @Test
    public void requirePositiveOk() {
        Preconditions.requirePositive((long)1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void requirePositiveFailsOnZero() {
        Preconditions.requirePositive((long)0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void requirePositiveFailsOnNegative() {
        Preconditions.requirePositive((long)-1L);
    }

    @Test
    public void requireNonNegativeOk() {
        Preconditions.requireNonNegative((long)0L);
        Preconditions.requireNonNegative((long)1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void requireNonNegativeFailsOnNegative() {
        Preconditions.requireNonNegative((long)-1L);
    }

    @Test
    public void checkStateOk() {
        Preconditions.checkState((boolean)true, (String)"must not fail");
    }

    @Test(expected=IllegalStateException.class)
    public void checkStateFails() {
        Preconditions.checkState((boolean)false, (String)"must fail");
    }
}

