/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class SafeLifecycle
implements Lifecycle {
    private State state;

    protected SafeLifecycle() {
        this(State.PRE);
    }

    SafeLifecycle(State state) {
        this.state = state;
    }

    private void transition(State expected, State to, Operation op, boolean force) throws Throwable {
        if (this.state != expected) {
            throw new IllegalStateException(String.format("Expected %s but was %s", new Object[]{expected, this.state}));
        }
        if (force) {
            this.state = to;
            op.run();
        } else {
            op.run();
            this.state = to;
        }
    }

    @Override
    public final synchronized void init() throws Throwable {
        this.transition(State.PRE, State.IDLE, this::init0, false);
    }

    @Override
    public final synchronized void start() throws Throwable {
        this.transition(State.IDLE, State.RUN, this::start0, false);
    }

    @Override
    public final synchronized void stop() throws Throwable {
        if (this.state == State.IDLE) {
            return;
        }
        this.transition(State.RUN, State.IDLE, this::stop0, true);
    }

    @Override
    public final synchronized void shutdown() throws Throwable {
        if (this.state == State.PRE) {
            this.state = State.HALT;
            return;
        }
        this.transition(State.IDLE, State.HALT, this::shutdown0, true);
    }

    public void init0() throws Throwable {
    }

    public void start0() throws Throwable {
    }

    public void stop0() throws Throwable {
    }

    public void shutdown0() throws Throwable {
    }

    public State state() {
        return this.state;
    }

    static interface Operation {
        public void run() throws Throwable;
    }

    static enum State {
        PRE,
        IDLE,
        RUN,
        HALT;

    }
}

