/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.enterprise.builtinprocs.ProceduresTimeFormatHelper;
import org.neo4j.kernel.enterprise.builtinprocs.QueryId;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.virtual.MapValue;

public class QueryStatusResult {
    public final String queryId;
    public final String username;
    public final Map<String, Object> metaData;
    public final String query;
    public final Map<String, Object> parameters;
    public final String planner;
    public final String runtime;
    public final List<Map<String, String>> indexes;
    public final String startTime;
    @Deprecated
    public final String elapsedTime;
    @Deprecated
    public final String connectionDetails;
    public final String protocol;
    public final String clientAddress;
    public final String requestUri;
    public final String status;
    public final Map<String, Object> resourceInformation;
    public final long activeLockCount;
    public final long elapsedTimeMillis;
    public final Long cpuTimeMillis;
    public final long waitTimeMillis;
    public final Long idleTimeMillis;
    public final Long allocatedBytes;
    public final long pageHits;
    public final long pageFaults;

    QueryStatusResult(ExecutingQuery query, EmbeddedProxySPI manager, ZoneId zoneId) throws InvalidArgumentsException {
        this(query.snapshot(), manager, zoneId);
    }

    private QueryStatusResult(QuerySnapshot query, EmbeddedProxySPI manager, ZoneId zoneId) throws InvalidArgumentsException {
        this.queryId = QueryId.ofInternalId(query.internalQueryId()).toString();
        this.username = query.username();
        this.query = query.queryText();
        this.parameters = this.asRawMap(query.queryParameters(), new ParameterWriter(manager));
        this.startTime = ProceduresTimeFormatHelper.formatTime(query.startTimestampMillis(), zoneId);
        this.elapsedTimeMillis = query.elapsedTimeMillis();
        this.elapsedTime = ProceduresTimeFormatHelper.formatInterval(this.elapsedTimeMillis);
        ClientConnectionInfo clientConnection = query.clientConnection();
        this.connectionDetails = clientConnection.asConnectionDetails();
        this.protocol = clientConnection.protocol();
        this.clientAddress = clientConnection.clientAddress();
        this.requestUri = clientConnection.requestURI();
        this.metaData = query.transactionAnnotationData();
        this.cpuTimeMillis = query.cpuTimeMillis();
        this.status = query.status();
        this.resourceInformation = query.resourceInformation();
        this.activeLockCount = query.activeLockCount();
        this.waitTimeMillis = query.waitTimeMillis();
        this.idleTimeMillis = query.idleTimeMillis();
        this.planner = query.planner();
        this.runtime = query.runtime();
        this.indexes = query.indexes();
        this.allocatedBytes = query.allocatedBytes();
        this.pageHits = query.pageHits();
        this.pageFaults = query.pageFaults();
    }

    private Map<String, Object> asRawMap(MapValue mapValue, ParameterWriter writer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        mapValue.foreach((s, value) -> {
            value.writeTo((AnyValueWriter)writer);
            map.put((String)s, writer.value());
        });
        return map;
    }

    private static class ParameterWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private final EmbeddedProxySPI nodeManager;

        private ParameterWriter(EmbeddedProxySPI nodeManager) {
            this.nodeManager = nodeManager;
        }

        protected Node newNodeProxyById(long id) {
            return this.nodeManager.newNodeProxy(id);
        }

        protected Relationship newRelationshipProxyById(long id) {
            return this.nodeManager.newRelationshipProxy(id);
        }

        protected Point newPoint(final CoordinateReferenceSystem crs, final double[] coordinate) {
            return new Point(){

                public String getGeometryType() {
                    return "Point";
                }

                public List<Coordinate> getCoordinates() {
                    return Collections.singletonList(new Coordinate(coordinate));
                }

                public CRS getCRS() {
                    return crs;
                }
            };
        }
    }
}

