/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.pagecache.Profile;

class ProfileRefCounts {
    private final Map<Profile, Counter> bag = new HashMap<Profile, Counter>();

    ProfileRefCounts() {
    }

    synchronized void incrementRefCounts(Profile[] profiles) {
        for (Profile profile : profiles) {
            this.bag.computeIfAbsent(profile, p -> new Counter()).increment();
        }
    }

    synchronized void decrementRefCounts(Profile[] profiles) {
        for (Profile profile : profiles) {
            this.bag.computeIfPresent(profile, (p, i) -> i.decrementAndGet() == 0 ? null : i);
        }
    }

    synchronized boolean contains(Profile profile) {
        return this.bag.containsKey(profile);
    }

    private static class Counter {
        private int count;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        int decrementAndGet() {
            return --this.count;
        }
    }
}

