/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.Deserializer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.Protocol320;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.kernel.ha.MasterClient310;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;

public class MasterClient320
extends MasterClient310 {
    public static final ProtocolVersion PROTOCOL_VERSION = new ProtocolVersion(10, 2);
    public static final ObjectSerializer<LockResult> LOCK_RESULT_OBJECT_SERIALIZER = (responseObject, result) -> {
        result.writeByte(responseObject.getStatus().ordinal());
        String message = responseObject.getMessage();
        if (message != null) {
            Protocol.writeString((ChannelBuffer)result, (String)message);
        } else {
            result.writeInt(0);
        }
    };
    public static final Deserializer<LockResult> LOCK_RESULT_DESERIALIZER = (buffer, temporaryBuffer) -> {
        LockStatus status;
        byte statusOrdinal = buffer.readByte();
        int messageLength = buffer.readInt();
        try {
            status = LockStatus.values()[statusOrdinal];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw MasterClient320.withInvalidOrdinalMessage(buffer, statusOrdinal, e);
        }
        if (messageLength > 0) {
            return new LockResult(status, Protocol.readString((ChannelBuffer)buffer, (int)messageLength));
        }
        return new LockResult(status);
    };

    public MasterClient320(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, LogProvider logProvider, StoreId storeId, long readTimeoutMillis, long lockReadTimeout, int maxConcurrentChannels, int chunkSize, ResponseUnpacker unpacker, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        super(destinationHostNameOrIp, destinationPort, originHostNameOrIp, logProvider, storeId, readTimeoutMillis, lockReadTimeout, maxConcurrentChannels, chunkSize, unpacker, byteCounterMonitor, requestMonitor, entryReader);
    }

    @Override
    protected Protocol createProtocol(int chunkSize, byte applicationProtocolVersion) {
        return new Protocol320(chunkSize, applicationProtocolVersion, this.getInternalProtocolVersion());
    }

    @Override
    public ObjectSerializer<LockResult> createLockResultSerializer() {
        return LOCK_RESULT_OBJECT_SERIALIZER;
    }

    @Override
    public Deserializer<LockResult> createLockResultDeserializer() {
        return LOCK_RESULT_DESERIALIZER;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return PROTOCOL_VERSION;
    }
}

