/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.StoreFileChannelUnwrapper;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.FileLockException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import sun.nio.ch.FileChannelImpl;

public class SingleFilePageSwapper
implements PageSwapper {
    private static final int MAX_INTERRUPTED_CHANNEL_REOPEN_ATTEMPTS = 42;
    private static final int channelStripePower = Integer.getInteger("org.neo4j.io.pagecache.implSingleFilePageSwapper.channelStripePower", SingleFilePageSwapper.defaultChannelStripePower());
    private static final int channelStripeShift = Integer.getInteger("org.neo4j.io.pagecache.implSingleFilePageSwapper.channelStripeShift", 4);
    private static final int channelStripeCount = 1 << channelStripePower;
    private static final int channelStripeMask = channelStripeCount - 1;
    private static final int tokenChannelStripe = 0;
    private static final long tokenFilePageId = 0L;
    private static final long fileSizeOffset = UnsafeUtil.getFieldOffset(SingleFilePageSwapper.class, (String)"fileSize");
    private static final ThreadLocal<ByteBuffer> proxyCache = new ThreadLocal();
    private static final MethodHandle positionLockGetter = SingleFilePageSwapper.getPositionLockGetter();
    private final FileSystemAbstraction fs;
    private final File file;
    private final int filePageSize;
    private volatile PageEvictionCallback onEviction;
    private final StoreChannel[] channels;
    private FileLock fileLock;
    private final boolean hasPositionLock;
    private boolean closed;
    private volatile long fileSize;

    private static int defaultChannelStripePower() {
        int vcores = Runtime.getRuntime().availableProcessors();
        int stripePower = 32 - Integer.numberOfLeadingZeros(vcores - 1);
        return Math.min(64, Math.max(1, stripePower));
    }

    private static MethodHandle getPositionLockGetter() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field field = FileChannelImpl.class.getDeclaredField("positionLock");
            field.setAccessible(true);
            return lookup.unreflectGetter(field);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ByteBuffer proxy(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf = proxyCache.get();
        if (buf != null) {
            UnsafeUtil.initDirectByteBuffer((Object)buf, (long)buffer, (int)bufferLength);
            return buf;
        }
        return SingleFilePageSwapper.createAndGetNewBuffer(buffer, bufferLength);
    }

    private static ByteBuffer createAndGetNewBuffer(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf;
        try {
            buf = UnsafeUtil.newDirectByteBuffer((long)buffer, (int)bufferLength);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        proxyCache.set(buf);
        return buf;
    }

    public SingleFilePageSwapper(File file, FileSystemAbstraction fs, int filePageSize, PageEvictionCallback onEviction) throws IOException {
        this.fs = fs;
        this.file = file;
        this.channels = new StoreChannel[channelStripeCount];
        for (int i = 0; i < channelStripeCount; ++i) {
            this.channels[i] = fs.open(file, OpenMode.READ_WRITE);
        }
        this.filePageSize = filePageSize;
        this.onEviction = onEviction;
        this.increaseFileSizeTo(this.channels[0].size());
        try {
            this.acquireLock();
        }
        catch (IOException e) {
            this.closeAndCollectExceptions(0, e);
        }
        this.hasPositionLock = this.channels[0].getClass() == StoreFileChannel.class && StoreFileChannelUnwrapper.unwrap(this.channels[0]).getClass() == FileChannelImpl.class;
    }

    private void increaseFileSizeTo(long newFileSize) {
        long currentFileSize;
        while ((currentFileSize = this.getCurrentFileSize()) < newFileSize && !UnsafeUtil.compareAndSwapLong((Object)this, (long)fileSizeOffset, (long)currentFileSize, (long)newFileSize)) {
        }
    }

    private long getCurrentFileSize() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)fileSizeOffset);
    }

    private void setCurrentFileSize(long size) {
        UnsafeUtil.putLongVolatile((Object)this, (long)fileSizeOffset, (long)size);
    }

    private void acquireLock() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        try {
            this.fileLock = this.channels[0].tryLock();
            if (this.fileLock == null) {
                throw new FileLockException(this.file);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new FileLockException(this.file, e);
        }
    }

    private StoreChannel channel(long filePageId) {
        int stripe = SingleFilePageSwapper.stripe(filePageId);
        return this.channels[stripe];
    }

    private static int stripe(long filePageId) {
        return (int)(filePageId >>> channelStripeShift) & channelStripeMask;
    }

    private int swapIn(StoreChannel channel, long bufferAddress, int bufferSize, long fileOffset, int filePageSize) throws IOException {
        int readTotal = 0;
        try {
            int read;
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(bufferAddress, filePageSize);
            while ((read = channel.read(bufferProxy, fileOffset + (long)readTotal)) != -1 && (readTotal += read) < filePageSize) {
            }
            assert (readTotal >= 0 && filePageSize <= bufferSize && readTotal <= filePageSize) : String.format("pointer = %h, readTotal = %s, length = %s, page size = %s", bufferAddress, readTotal, filePageSize, bufferSize);
            UnsafeUtil.setMemory((long)(bufferAddress + (long)readTotal), (long)(filePageSize - readTotal), (byte)MuninnPageCache.ZERO_BYTE);
            return readTotal;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = String.format("Read failed after %s of %s bytes from fileOffset %s", readTotal, filePageSize, fileOffset);
            throw new IOException(msg, e);
        }
    }

    private int swapOut(long bufferAddress, long fileOffset, StoreChannel channel) throws IOException {
        try {
            ByteBuffer bufferProxy = SingleFilePageSwapper.proxy(bufferAddress, this.filePageSize);
            channel.writeAll(bufferProxy, fileOffset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        return this.filePageSize;
    }

    private void clear(long bufferAddress, int bufferSize) {
        UnsafeUtil.setMemory((long)bufferAddress, (long)bufferSize, (byte)MuninnPageCache.ZERO_BYTE);
    }

    @Override
    public long read(long filePageId, long bufferAddress, int bufferSize) throws IOException {
        return this.readAndRetryIfInterrupted(filePageId, bufferAddress, bufferSize, 42);
    }

    private long readAndRetryIfInterrupted(long filePageId, long bufferAddress, int bufferSize, int attemptsLeft) throws IOException {
        long fileOffset = this.pageIdToPosition(filePageId);
        try {
            if (fileOffset < this.getCurrentFileSize()) {
                return this.swapIn(this.channel(filePageId), bufferAddress, bufferSize, fileOffset, this.filePageSize);
            }
            this.clear(bufferAddress, bufferSize);
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            if (attemptsLeft < 1) {
                throw new IOException("IO failed due to interruption", e);
            }
            boolean interrupted = Thread.interrupted();
            long bytesRead = this.readAndRetryIfInterrupted(filePageId, bufferAddress, bufferSize, attemptsLeft - 1);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesRead;
        }
        return 0L;
    }

    @Override
    public long read(long startFilePageId, long[] bufferAddresses, int bufferSize, int arrayOffset, int length) throws IOException {
        if (positionLockGetter != null && this.hasPositionLock) {
            try {
                return this.readPositionedVectoredToFileChannel(startFilePageId, bufferAddresses, arrayOffset, length);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.readPositionedVectoredFallback(startFilePageId, bufferAddresses, bufferSize, arrayOffset, length);
    }

    private long readPositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws Exception {
        ByteBuffer[] srcs;
        long fileOffset = this.pageIdToPosition(startFilePageId);
        FileChannel channel = this.unwrappedChannel(startFilePageId);
        long bytesRead = this.lockPositionReadVectorAndRetryIfInterrupted(startFilePageId, channel, fileOffset, srcs = this.convertToByteBuffers(bufferAddresses, arrayOffset, length), 42);
        if (bytesRead == -1L) {
            for (long address : bufferAddresses) {
                UnsafeUtil.setMemory((long)address, (long)this.filePageSize, (byte)MuninnPageCache.ZERO_BYTE);
            }
            return 0L;
        }
        if (bytesRead < (long)this.filePageSize * (long)length) {
            int pagesRead = (int)(bytesRead / (long)this.filePageSize);
            int bytesReadIntoLastReadPage = (int)(bytesRead % (long)this.filePageSize);
            int pagesNeedingZeroing = length - pagesRead;
            for (int i = 0; i < pagesNeedingZeroing; ++i) {
                long address = bufferAddresses[arrayOffset + pagesRead + i];
                long bytesToZero = this.filePageSize;
                if (i == 0) {
                    address += (long)bytesReadIntoLastReadPage;
                    bytesToZero -= (long)bytesReadIntoLastReadPage;
                }
                UnsafeUtil.setMemory((long)address, (long)bytesToZero, (byte)MuninnPageCache.ZERO_BYTE);
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionReadVectorAndRetryIfInterrupted(long filePageId, FileChannel channel, long fileOffset, ByteBuffer[] srcs, int attemptsLeft) throws IOException {
        try {
            long toRead = (long)this.filePageSize * (long)srcs.length;
            long readTotal = 0L;
            Object object = this.positionLock(channel);
            synchronized (object) {
                long read;
                channel.position(fileOffset);
                while ((read = channel.read(srcs)) != -1L && (readTotal += read) < toRead) {
                }
                return readTotal;
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            if (attemptsLeft < 1) {
                throw new IOException("IO failed due to interruption", e);
            }
            boolean interrupted = Thread.interrupted();
            channel = this.unwrappedChannel(filePageId);
            long bytesWritten = this.lockPositionReadVectorAndRetryIfInterrupted(filePageId, channel, fileOffset, srcs, attemptsLeft - 1);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesWritten;
        }
    }

    private int readPositionedVectoredFallback(long startFilePageId, long[] bufferAddresses, int bufferSize, int arrayOffset, int length) throws IOException {
        int bytes = 0;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[arrayOffset + i];
            bytes = (int)((long)bytes + this.read(startFilePageId + (long)i, address, bufferSize));
        }
        return bytes;
    }

    @Override
    public long write(long filePageId, long bufferAddress) throws IOException {
        return this.writeAndRetryIfInterrupted(filePageId, bufferAddress, 42);
    }

    private long writeAndRetryIfInterrupted(long filePageId, long bufferAddress, int attemptsLeft) throws IOException {
        long fileOffset = this.pageIdToPosition(filePageId);
        this.increaseFileSizeTo(fileOffset + (long)this.filePageSize);
        try {
            StoreChannel channel = this.channel(filePageId);
            return this.swapOut(bufferAddress, fileOffset, channel);
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            if (attemptsLeft < 1) {
                throw new IOException("IO failed due to interruption", e);
            }
            boolean interrupted = Thread.interrupted();
            long bytesWritten = this.writeAndRetryIfInterrupted(filePageId, bufferAddress, attemptsLeft - 1);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesWritten;
        }
    }

    @Override
    public long write(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        if (positionLockGetter != null && this.hasPositionLock) {
            try {
                return this.writePositionedVectoredToFileChannel(startFilePageId, bufferAddresses, arrayOffset, length);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.writePositionVectoredFallback(startFilePageId, bufferAddresses, arrayOffset, length);
    }

    private long writePositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws Exception {
        long fileOffset = this.pageIdToPosition(startFilePageId);
        this.increaseFileSizeTo(fileOffset + (long)this.filePageSize * (long)length);
        FileChannel channel = this.unwrappedChannel(startFilePageId);
        ByteBuffer[] srcs = this.convertToByteBuffers(bufferAddresses, arrayOffset, length);
        return this.lockPositionWriteVectorAndRetryIfInterrupted(startFilePageId, channel, fileOffset, srcs, 42);
    }

    private ByteBuffer[] convertToByteBuffers(long[] bufferAddresses, int arrayOffset, int length) throws Exception {
        ByteBuffer[] buffers = new ByteBuffer[length];
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[arrayOffset + i];
            buffers[i] = UnsafeUtil.newDirectByteBuffer((long)address, (int)this.filePageSize);
        }
        return buffers;
    }

    private FileChannel unwrappedChannel(long startFilePageId) {
        StoreChannel storeChannel = this.channel(startFilePageId);
        return StoreFileChannelUnwrapper.unwrap(storeChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionWriteVectorAndRetryIfInterrupted(long filePageId, FileChannel channel, long fileOffset, ByteBuffer[] srcs, int attemptsLeft) throws IOException {
        try {
            long toWrite = (long)this.filePageSize * (long)srcs.length;
            long bytesWritten = 0L;
            Object object = this.positionLock(channel);
            synchronized (object) {
                channel.position(fileOffset);
                while ((bytesWritten += channel.write(srcs)) < toWrite) {
                }
                return bytesWritten;
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(filePageId, e);
            if (attemptsLeft < 1) {
                throw new IOException("IO failed due to interruption", e);
            }
            boolean interrupted = Thread.interrupted();
            channel = this.unwrappedChannel(filePageId);
            long bytesWritten = this.lockPositionWriteVectorAndRetryIfInterrupted(filePageId, channel, fileOffset, srcs, attemptsLeft - 1);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesWritten;
        }
    }

    private Object positionLock(FileChannel channel) {
        FileChannelImpl impl = (FileChannelImpl)channel;
        try {
            return positionLockGetter.invokeExact(impl);
        }
        catch (Throwable th) {
            throw new LinkageError("No getter for FileChannel.positionLock", th);
        }
    }

    private int writePositionVectoredFallback(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
        int bytes = 0;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[arrayOffset + i];
            bytes = (int)((long)bytes + this.write(startFilePageId + (long)i, address));
        }
        return bytes;
    }

    @Override
    public void evicted(long filePageId) {
        PageEvictionCallback callback = this.onEviction;
        if (callback != null) {
            callback.onEvict(filePageId);
        }
    }

    @Override
    public File file() {
        return this.file;
    }

    private long pageIdToPosition(long pageId) {
        return (long)this.filePageSize * pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFilePageSwapper that = (SingleFilePageSwapper)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private synchronized void tryReopen(long filePageId, ClosedChannelException closedException) throws ClosedChannelException {
        int stripe = SingleFilePageSwapper.stripe(filePageId);
        StoreChannel channel = this.channels[stripe];
        if (channel.isOpen()) {
            return;
        }
        if (this.closed) {
            throw closedException;
        }
        try {
            this.channels[stripe] = this.fs.open(this.file, OpenMode.READ_WRITE);
            if (stripe == 0) {
                this.acquireLock();
            }
        }
        catch (IOException e) {
            closedException.addSuppressed(e);
            throw closedException;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        try {
            this.closeAndCollectExceptions(0, null);
        }
        finally {
            this.onEviction = null;
        }
    }

    private void closeAndCollectExceptions(int channelIndex, IOException exception) throws IOException {
        if (channelIndex == this.channels.length) {
            if (exception != null) {
                throw exception;
            }
            return;
        }
        try {
            this.channels[channelIndex].close();
        }
        catch (IOException e) {
            if (exception == null) {
                exception = e;
            }
            exception.addSuppressed(e);
        }
        this.closeAndCollectExceptions(channelIndex + 1, exception);
    }

    @Override
    public synchronized void closeAndDelete() throws IOException {
        this.close();
        this.fs.deleteFile(this.file);
    }

    @Override
    public void force() throws IOException {
        this.forceAndRetryIfInterrupted(42);
    }

    private void forceAndRetryIfInterrupted(int attemptsLeft) throws IOException {
        block3: {
            try {
                this.channel(0L).force(false);
            }
            catch (ClosedChannelException e) {
                this.tryReopen(0L, e);
                if (attemptsLeft < 1) {
                    throw new IOException("IO failed due to interruption", e);
                }
                boolean interrupted = Thread.interrupted();
                this.forceAndRetryIfInterrupted(attemptsLeft - 1);
                if (!interrupted) break block3;
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public long getLastPageId() {
        long channelSize = this.getCurrentFileSize();
        if (channelSize == 0L) {
            return -1L;
        }
        long div = channelSize / (long)this.filePageSize;
        long mod = channelSize % (long)this.filePageSize;
        return mod == 0L ? div - 1L : div;
    }

    @Override
    public void truncate() throws IOException {
        this.truncateAndRetryIfInterrupted(42);
    }

    private void truncateAndRetryIfInterrupted(int attemptsLeft) throws IOException {
        block3: {
            this.setCurrentFileSize(0L);
            try {
                this.channel(0L).truncate(0L);
            }
            catch (ClosedChannelException e) {
                this.tryReopen(0L, e);
                if (attemptsLeft < 1) {
                    throw new IOException("IO failed due to interruption", e);
                }
                boolean interrupted = Thread.interrupted();
                this.truncateAndRetryIfInterrupted(attemptsLeft - 1);
                if (!interrupted) break block3;
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return "SingleFilePageSwapper{filePageSize=" + this.filePageSize + ", file=" + this.file + '}';
    }
}

