/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;

public class SchemaFacadeMethods {
    private static final Label LABEL = Label.label((String)"Label");
    private static final IndexDefinition INDEX_DEFINITION = (IndexDefinition)Mockito.mock(IndexDefinition.class);
    private static final FacadeMethod<Schema> INDEX_FOR = new FacadeMethod<Schema>("IndexCreator indexFor( Label label )"){

        @Override
        public void call(Schema self) {
            self.indexFor(LABEL);
        }
    };
    private static final FacadeMethod<Schema> GET_INDEXES_BY_LABEL = new FacadeMethod<Schema>("Iterable<IndexDefinition> getIndexes( Label label )"){

        @Override
        public void call(Schema self) {
            self.getIndexes(LABEL);
        }
    };
    private static final FacadeMethod<Schema> GET_INDEXES = new FacadeMethod<Schema>("Iterable<IndexDefinition> getIndexes()"){

        @Override
        public void call(Schema self) {
            self.getIndexes();
        }
    };
    private static final FacadeMethod<Schema> GET_INDEX_STATE = new FacadeMethod<Schema>("IndexState getIndexState( IndexDefinition index )"){

        @Override
        public void call(Schema self) {
            self.getIndexState(INDEX_DEFINITION);
        }
    };
    private static final FacadeMethod<Schema> GET_INDEX_FAILURE = new FacadeMethod<Schema>("String getIndexFailure( IndexDefinition index )"){

        @Override
        public void call(Schema self) {
            self.getIndexFailure(INDEX_DEFINITION);
        }
    };
    private static final FacadeMethod<Schema> CONSTRAINT_FOR = new FacadeMethod<Schema>("ConstraintCreator constraintFor( Label label )"){

        @Override
        public void call(Schema self) {
            self.constraintFor(LABEL);
        }
    };
    private static final FacadeMethod<Schema> GET_CONSTRAINTS_BY_LABEL = new FacadeMethod<Schema>("Iterable<ConstraintDefinition> getConstraints( Label label )"){

        @Override
        public void call(Schema self) {
            self.getConstraints(LABEL);
        }
    };
    private static final FacadeMethod<Schema> GET_CONSTRAINTS = new FacadeMethod<Schema>("Iterable<ConstraintDefinition> getConstraints()"){

        @Override
        public void call(Schema self) {
            self.getConstraints();
        }
    };
    private static final FacadeMethod<Schema> AWAIT_INDEX_ONLINE = new FacadeMethod<Schema>("void awaitIndexOnline( IndexDefinition index, long duration, TimeUnit unit )"){

        @Override
        public void call(Schema self) {
            self.awaitIndexOnline(INDEX_DEFINITION, 1L, TimeUnit.SECONDS);
        }
    };
    private static final FacadeMethod<Schema> AWAIT_INDEXES_ONLINE = new FacadeMethod<Schema>("void awaitIndexesOnline( long duration, TimeUnit unit )"){

        @Override
        public void call(Schema self) {
            self.awaitIndexesOnline(1L, TimeUnit.SECONDS);
        }
    };
    static final Iterable<FacadeMethod<Schema>> ALL_SCHEMA_FACADE_METHODS = Collections.unmodifiableCollection(Arrays.asList(INDEX_FOR, GET_INDEXES_BY_LABEL, GET_INDEXES, GET_INDEX_STATE, GET_INDEX_FAILURE, CONSTRAINT_FOR, GET_CONSTRAINTS_BY_LABEL, GET_CONSTRAINTS, AWAIT_INDEX_ONLINE, AWAIT_INDEXES_ONLINE));

    private SchemaFacadeMethods() {
    }
}

