/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Exceptions;

public class TestExceptions {
    @Test
    public void canPeelExceptions() {
        LevelThreeException expected = new LevelThreeException("include", new LevelFourException(""));
        LevelOneException exception = new LevelOneException("", new LevelTwoException("", new LevelThreeException("", expected)));
        Throwable peeled = Exceptions.peel((Throwable)exception, item -> !(item instanceof LevelThreeException) || !item.getMessage().contains("include"));
        Assert.assertEquals((Object)expected, (Object)peeled);
    }

    @Test
    public void canPeelUsingConveniencePredicate() {
        LevelThreeException expected = new LevelThreeException("", new LevelFourException(""));
        ARuntimeException exception = new ARuntimeException(new AnotherRuntimeException(new LevelFourException("", expected)));
        Throwable peeled = Exceptions.peel((Throwable)exception, (Predicate)Predicates.instanceOfAny((Class[])new Class[]{RuntimeException.class, LevelFourException.class}));
        Assert.assertEquals((Object)expected, (Object)peeled);
    }

    @Test
    public void shouldDetectContainsOneOfSome() {
        ARuntimeException cause = new ARuntimeException(new AnotherRuntimeException(new NullPointerException("Some words")));
        Assert.assertTrue((boolean)Exceptions.contains((Throwable)cause, (Class[])new Class[]{NullPointerException.class}));
        Assert.assertTrue((boolean)Exceptions.contains((Throwable)cause, (String)"words", (Class[])new Class[]{NullPointerException.class}));
        Assert.assertFalse((boolean)Exceptions.contains((Throwable)cause, (String)"not", (Class[])new Class[]{NullPointerException.class}));
    }

    @Test
    public void shouldSetMessage() {
        String initialMessage = "Initial message";
        LevelOneException exception = new LevelOneException(initialMessage);
        String prependedMessage = "Prepend this: " + exception.getMessage();
        Exceptions.withMessage((Throwable)exception, (String)prependedMessage);
        Assert.assertEquals((Object)prependedMessage, (Object)exception.getMessage());
    }

    private static class AnotherRuntimeException
    extends RuntimeException {
        AnotherRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class ARuntimeException
    extends RuntimeException {
        ARuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class LevelFourException
    extends LevelThreeException {
        LevelFourException(String message) {
            super(message);
        }

        LevelFourException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelThreeException
    extends LevelTwoException {
        LevelThreeException(String message) {
            super(message);
        }

        LevelThreeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelTwoException
    extends LevelOneException {
        LevelTwoException(String message) {
            super(message);
        }

        LevelTwoException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelOneException
    extends Exception {
        LevelOneException(String message) {
            super(message);
        }

        LevelOneException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

