/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.TestDirectory;

public class CommunityEditionModuleIntegrationTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBufferedIdComponentsByDefault() {
        GraphDatabaseAPI database = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
        try {
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            IdController idController = (IdController)dependencyResolver.resolveDependency(IdController.class);
            IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)dependencyResolver.resolveDependency(IdGeneratorFactory.class);
            Assert.assertThat((Object)idController, (Matcher)Matchers.instanceOf(BufferedIdController.class));
            Assert.assertThat((Object)idGeneratorFactory, (Matcher)Matchers.instanceOf(BufferingIdGeneratorFactory.class));
        }
        finally {
            database.shutdown();
        }
    }

    @Test
    public void fileWatcherFileNameFilter() {
        Predicate filter = CommunityEditionModule.communityFileWatcherFileNameFilter();
        Assert.assertFalse((boolean)filter.test("neostore"));
        Assert.assertFalse((boolean)filter.test(StoreFile.NODE_STORE.fileName(StoreFileType.STORE)));
        Assert.assertTrue((boolean)filter.test("neostore.transaction.db.1"));
        Assert.assertTrue((boolean)filter.test("index.db.any"));
    }
}

