/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.IntFunction;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;

@RunWith(value=Parameterized.class)
public class FusionIndexUpdaterTest {
    private IndexUpdater[] aliveUpdaters;
    private IndexUpdater[] updaters;
    private FusionIndexUpdater fusionIndexUpdater;
    @Rule
    public RandomRule random = new RandomRule();
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        int[] activeSlots = fusionVersion.aliveSlots();
        this.updaters = new IndexUpdater[5];
        Arrays.fill(this.updaters, SwallowingIndexUpdater.INSTANCE);
        this.aliveUpdaters = new IndexUpdater[activeSlots.length];
        block7: for (int i = 0; i < activeSlots.length; ++i) {
            IndexUpdater mock;
            this.aliveUpdaters[i] = mock = (IndexUpdater)Mockito.mock(IndexUpdater.class);
            switch (activeSlots[i]) {
                case 0: {
                    this.updaters[0] = mock;
                    continue block7;
                }
                case 1: {
                    this.updaters[1] = mock;
                    continue block7;
                }
                case 2: {
                    this.updaters[2] = mock;
                    continue block7;
                }
                case 3: {
                    this.updaters[3] = mock;
                    continue block7;
                }
                case 4: {
                    this.updaters[4] = mock;
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexUpdater = new FusionIndexUpdater(fusionVersion.slotSelector(), new LazyInstanceSelector((Object[])this.updaters, this.throwingFactory()));
    }

    private IntFunction<IndexUpdater> throwingFactory() {
        return i -> {
            throw new IllegalStateException("All updaters should exist already");
        };
    }

    private void resetMocks() {
        for (IndexUpdater updater : this.aliveUpdaters) {
            Mockito.reset((Object[])new IndexUpdater[]{updater});
        }
    }

    @Test
    public void processMustSelectCorrectForAdd() throws Exception {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (int i = 0; i < this.updaters.length; ++i) {
            Value[] valueArray = values[i];
            int n = valueArray.length;
            for (int j = 0; j < n; ++j) {
                Value value = valueArray[j];
                this.verifyAddWithCorrectUpdater(this.orLucene(this.updaters[i]), value);
            }
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyAddWithCorrectUpdater(this.updaters[4], firstValue, secondValue);
            }
        }
    }

    @Test
    public void processMustSelectCorrectForRemove() throws Exception {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (int i = 0; i < this.updaters.length; ++i) {
            Value[] valueArray = values[i];
            int n = valueArray.length;
            for (int j = 0; j < n; ++j) {
                Value value = valueArray[j];
                this.verifyRemoveWithCorrectUpdater(this.orLucene(this.updaters[i]), value);
            }
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyRemoveWithCorrectUpdater(this.updaters[4], firstValue, secondValue);
            }
        }
    }

    @Test
    public void processMustSelectCorrectForChange() throws Exception {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        for (int i = 0; i < this.updaters.length; ++i) {
            for (Value before : values[i]) {
                for (Value after : values[i]) {
                    this.verifyChangeWithCorrectUpdaterNotMixed(this.orLucene(this.updaters[i]), before, after);
                }
            }
        }
    }

    @Test
    public void processMustSelectCorrectForChangeFromOneGroupToAnother() throws Exception {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        for (int f = 0; f < values.length; ++f) {
            for (int t = 0; t < values.length; ++t) {
                if (f != t) {
                    this.verifyChangeWithCorrectUpdaterMixed(this.orLucene(this.updaters[f]), this.orLucene(this.updaters[t]), values[f], values[t]);
                } else {
                    this.verifyChangeWithCorrectUpdaterNotMixed(this.orLucene(this.updaters[f]), values[f]);
                }
                this.resetMocks();
            }
        }
    }

    private IndexUpdater orLucene(IndexUpdater updater) {
        return updater != SwallowingIndexUpdater.INSTANCE ? updater : this.updaters[4];
    }

    private void verifyAddWithCorrectUpdater(IndexUpdater correctPopulator, Value ... numberValues) throws IndexEntryConflictException, IOException {
        IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.add(numberValues);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).process(update);
        for (IndexUpdater populator : this.aliveUpdaters) {
            if (populator == correctPopulator) continue;
            ((IndexUpdater)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).process(update);
        }
    }

    private void verifyRemoveWithCorrectUpdater(IndexUpdater correctPopulator, Value ... numberValues) throws IndexEntryConflictException, IOException {
        IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.remove(numberValues);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).process(update);
        for (IndexUpdater populator : this.aliveUpdaters) {
            if (populator == correctPopulator) continue;
            ((IndexUpdater)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).process(update);
        }
    }

    private void verifyChangeWithCorrectUpdaterNotMixed(IndexUpdater correctPopulator, Value before, Value after) throws IndexEntryConflictException, IOException {
        IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.change(before, after);
        this.fusionIndexUpdater.process(update);
        ((IndexUpdater)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).process(update);
        for (IndexUpdater populator : this.aliveUpdaters) {
            if (populator == correctPopulator) continue;
            ((IndexUpdater)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).process(update);
        }
    }

    private void verifyChangeWithCorrectUpdaterNotMixed(IndexUpdater updater, Value[] supportedValues) throws IndexEntryConflictException, IOException {
        for (Value before : supportedValues) {
            for (Value after : supportedValues) {
                this.verifyChangeWithCorrectUpdaterNotMixed(updater, before, after);
            }
        }
    }

    private void verifyChangeWithCorrectUpdaterMixed(IndexUpdater expectRemoveFrom, IndexUpdater expectAddTo, Value[] beforeValues, Value[] afterValues) throws IOException, IndexEntryConflictException {
        for (int beforeIndex = 0; beforeIndex < beforeValues.length; ++beforeIndex) {
            Value before = beforeValues[beforeIndex];
            for (int afterIndex = 0; afterIndex < afterValues.length; ++afterIndex) {
                Value after = afterValues[afterIndex];
                IndexEntryUpdate<LabelSchemaDescriptor> change = FusionIndexTestHelp.change(before, after);
                this.fusionIndexUpdater.process(change);
                if (expectRemoveFrom != expectAddTo) {
                    ((IndexUpdater)Mockito.verify((Object)expectRemoveFrom, (VerificationMode)Mockito.times((int)(afterIndex + 1)))).process(FusionIndexTestHelp.remove(before));
                    ((IndexUpdater)Mockito.verify((Object)expectAddTo, (VerificationMode)Mockito.times((int)(beforeIndex + 1)))).process(FusionIndexTestHelp.add(after));
                    continue;
                }
                ((IndexUpdater)Mockito.verify((Object)expectRemoveFrom, (VerificationMode)Mockito.times((int)1))).process(FusionIndexTestHelp.change(before, after));
            }
        }
    }

    @Test
    public void closeMustCloseAll() throws Exception {
        this.fusionIndexUpdater.close();
        for (IndexUpdater updater : this.aliveUpdaters) {
            ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void closeMustThrowIfAnyThrow() throws Exception {
        for (int i = 0; i < this.aliveUpdaters.length; ++i) {
            IndexUpdater updater = this.aliveUpdaters[i];
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)updater, (AutoCloseable)this.fusionIndexUpdater);
            this.initiateMocks();
        }
    }

    @Test
    public void closeMustCloseOthersIfAnyThrow() throws Exception {
        for (int i = 0; i < this.aliveUpdaters.length; ++i) {
            IndexUpdater updater = this.aliveUpdaters[i];
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)updater, (AutoCloseable)this.fusionIndexUpdater, (AutoCloseable[])ArrayUtil.without((Object[])this.aliveUpdaters, (Object[])new IndexUpdater[]{updater}));
            this.initiateMocks();
        }
    }

    @Test
    public void closeMustThrowIfAllThrow() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowIfAllThrow((AutoCloseable)this.fusionIndexUpdater, (AutoCloseable[])this.aliveUpdaters);
    }

    @Test
    public void shouldInstantiatePartLazilyForSpecificValueGroupUpdates() throws IOException, IndexEntryConflictException {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        for (int i = 0; i < this.updaters.length; ++i) {
            if (this.updaters[i] != SwallowingIndexUpdater.INSTANCE) {
                Value value = values[i][0];
                this.fusionIndexUpdater.process(FusionIndexTestHelp.add(value));
                for (int j = 0; j < this.updaters.length; ++j) {
                    if (this.updaters[j] == SwallowingIndexUpdater.INSTANCE) continue;
                    if (i == j) {
                        ((IndexUpdater)Mockito.verify((Object)this.updaters[i])).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
                        continue;
                    }
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updaters[j]});
                }
            }
            this.initiateMocks();
        }
    }
}

