/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class NeoStoreOpenFailureTest {
    @Rule
    public PageCacheAndDependenciesRule rules = new PageCacheAndDependenciesRule(DefaultFileSystemRule::new, null);

    @Test
    public void mustCloseAllStoresIfNeoStoresFailToOpen() {
        PageCache pageCache = this.rules.pageCache();
        File dir = this.rules.directory().directory("dir");
        File neoStoreFile = new File(dir, "neostore");
        Config config = Config.defaults();
        FileSystemAbstraction fs = this.rules.fileSystem();
        DefaultIdGeneratorFactory idGenFactory = new DefaultIdGeneratorFactory(fs);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        VersionContextSupplier versions = EmptyVersionContextSupplier.EMPTY;
        RecordFormats formats = Standard.LATEST_RECORD_FORMATS;
        new RecordFormatPropertyConfigurator(formats, config).configure();
        boolean create = true;
        StoreType[] storeTypes = StoreType.values();
        OpenOption[] openOptions = new OpenOption[]{};
        NeoStores neoStores = new NeoStores(neoStoreFile, config, (IdGeneratorFactory)idGenFactory, pageCache, (LogProvider)logProvider, fs, versions, formats, create, storeTypes, openOptions);
        File schemaStore = neoStores.getSchemaStore().getStorageFileName();
        neoStores.close();
        Assume.assumeTrue((boolean)schemaStore.setReadable(false));
        Assume.assumeTrue((boolean)schemaStore.setWritable(false));
        try {
            new NeoStores(neoStoreFile, config, (IdGeneratorFactory)idGenFactory, pageCache, (LogProvider)logProvider, fs, versions, formats, create, storeTypes, openOptions);
            Assert.fail((String)"Opening NeoStores should have thrown.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        pageCache.close();
    }
}

