/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_2;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class StoreMigratorTest {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final RandomRule random = new RandomRule();
    private PageCache pageCache;
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule).around((TestRule)this.random);

    @Before
    public void setUp() {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule);
    }

    @Test
    public void shouldExtractTransactionInformationFromMetaDataStore() throws Exception {
        long txId = 42L;
        long checksum = 123456789123456789L;
        long timestamp = 919191919191919191L;
        TransactionId expected = new TransactionId(txId, checksum, timestamp);
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        Config config = (Config)Mockito.mock(Config.class);
        LogService logService = (LogService)Mockito.mock(LogService.class);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)txId);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, (long)checksum);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, (long)timestamp);
        StoreMigrator migrator = new StoreMigrator(this.fileSystemRule.get(), this.pageCache, config, logService);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldGenerateTransactionInformationWhenLogsNotPresent() throws Exception {
        long txId = 42L;
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        Config config = (Config)Mockito.mock(Config.class);
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP));
        StoreMigrator migrator = new StoreMigrator(this.fileSystemRule.get(), this.pageCache, config, (LogService)logService);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((long)txId, (long)actual.transactionId());
        Assert.assertEquals((long)1L, (long)actual.checksum());
        Assert.assertEquals((long)1L, (long)actual.commitTimestamp());
    }

    @Test
    public void extractTransactionInformationFromLogsInCustomRelativeLocation() throws Exception {
        File storeDir = this.directory.graphDbDir();
        File customLogLocation = new File(storeDir, "customLogLocation");
        this.extractTransactionalInformationFromLogs(customLogLocation.getName(), customLogLocation, storeDir);
    }

    @Test
    public void extractTransactionInformationFromLogsInCustomAbsoluteLocation() throws Exception {
        File storeDir = this.directory.graphDbDir();
        File customLogLocation = this.directory.directory("customLogLocation");
        this.extractTransactionalInformationFromLogs(customLogLocation.getAbsolutePath(), customLogLocation, storeDir);
    }

    private void extractTransactionalInformationFromLogs(String path, File customLogLocation, File storeDir) throws IOException {
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        File neoStore = new File(storeDir, "neostore");
        GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.logical_logs_location, path).newGraphDatabase();
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = database.createNode();
                transaction.success();
                continue;
            }
        }
        database.shutdown();
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, (long)-1L);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.logical_logs_location, (String)path);
        StoreMigrator migrator = new StoreMigrator(this.fileSystemRule.get(), this.pageCache, config, (LogService)logService);
        LogPosition logPosition = migrator.extractTransactionLogPosition(neoStore, storeDir, 100L);
        File[] logFiles = customLogLocation.listFiles();
        Assert.assertNotNull((Object)logFiles);
        Assert.assertEquals((long)0L, (long)logPosition.getLogVersion());
        Assert.assertEquals((long)logFiles[0].length(), (long)logPosition.getByteOffset());
    }

    @Test
    public void shouldGenerateTransactionInformationWhenLogsAreEmpty() throws Exception {
        long txId = 1L;
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        Config config = (Config)Mockito.mock(Config.class);
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP));
        StoreMigrator migrator = new StoreMigrator(this.fileSystemRule.get(), this.pageCache, config, (LogService)logService);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((long)txId, (long)actual.transactionId());
        Assert.assertEquals((long)0L, (long)actual.checksum());
        Assert.assertEquals((long)0L, (long)actual.commitTimestamp());
    }

    @Test
    public void writeAndReadLastTxInformation() throws IOException {
        StoreMigrator migrator = this.newStoreMigrator();
        TransactionId writtenTxId = new TransactionId(this.random.nextLong(), this.random.nextLong(), this.random.nextLong());
        migrator.writeLastTxInformation(this.directory.graphDbDir(), writtenTxId);
        TransactionId readTxId = migrator.readLastTxInformation(this.directory.graphDbDir());
        Assert.assertEquals((Object)writtenTxId, (Object)readTxId);
    }

    @Test
    public void writeAndReadLastTxLogPosition() throws IOException {
        StoreMigrator migrator = this.newStoreMigrator();
        LogPosition writtenLogPosition = new LogPosition(this.random.nextLong(), this.random.nextLong());
        migrator.writeLastTxLogPosition(this.directory.graphDbDir(), writtenLogPosition);
        LogPosition readLogPosition = migrator.readLastTxLogPosition(this.directory.graphDbDir());
        Assert.assertEquals((Object)writtenLogPosition, (Object)readLogPosition);
    }

    @Test
    public void shouldNotMigrateFilesForVersionsWithSameCapability() throws Exception {
        StoreMigrator migrator = this.newStoreMigrator();
        File graphDbDir = this.directory.graphDbDir();
        File neoStore = new File(graphDbDir, "neostore");
        neoStore.createNewFile();
        MyProgressReporter progressReporter = new MyProgressReporter();
        migrator.migrate(graphDbDir, this.directory.directory("migrationDir"), (ProgressReporter)progressReporter, StandardV3_0.STORE_VERSION, StandardV3_2.STORE_VERSION);
        Assert.assertFalse((boolean)progressReporter.started);
    }

    private StoreMigrator newStoreMigrator() {
        return new StoreMigrator((FileSystemAbstraction)this.fileSystemRule, this.pageCache, Config.defaults(), (LogService)NullLogService.getInstance());
    }

    private static class MyProgressReporter
    implements ProgressReporter {
        public boolean started;

        private MyProgressReporter() {
        }

        public void start(long max) {
            this.started = true;
        }

        public void progress(long add) {
        }

        public void completed() {
        }
    }
}

