/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

public class LogEntryParserDispatcherV6Test {
    private final LogEntryVersion version = LogEntryVersion.CURRENT;
    private final CommandReaderFactory commandReader = new RecordStorageCommandReaderFactory();
    private final LogPositionMarker marker = new LogPositionMarker();
    private final LogPosition position = new LogPosition(0L, 29L);

    @Test
    public void shouldParserStartEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(this.version, 1, 2, 3L, 4L, new byte[]{5}, this.position);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)1);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)start, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParserOnePhaseCommitEntry() throws IOException {
        LogEntryCommit commit = new LogEntryCommit(this.version, 42L, 21L);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)5);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)commit, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParserCommandsUsingAGivenFactory() throws IOException {
        NodeRecord theRecord = new NodeRecord(1L);
        Command.NodeCommand nodeCommand = new Command.NodeCommand(theRecord, theRecord);
        LogEntryCommand command = new LogEntryCommand(this.version, (StorageCommand)nodeCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put((byte)1);
        channel.putLong(theRecord.getId());
        channel.put((byte)0);
        channel.putInt(0);
        channel.put((byte)0);
        channel.putInt(0);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)3);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)command, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseCheckPointEntry() throws IOException {
        CheckPoint checkPoint = new CheckPoint(new LogPosition(43L, 44L));
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(checkPoint.getLogPosition().getLogVersion());
        channel.putLong(checkPoint.getLogPosition().getByteOffset());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)7);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)checkPoint, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenParsingUnknownEntry() {
        this.version.entryParser((byte)42);
    }
}

