/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.index.impl.lucene.explicit.CommitContext;
import org.neo4j.index.impl.lucene.explicit.EntityId;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexType;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;

public class LuceneCommandApplier
extends TransactionApplier.Adapter {
    private final LuceneDataSource dataSource;
    private final Map<String, CommitContext> nodeContexts = new HashMap<String, CommitContext>();
    private final Map<String, CommitContext> relationshipContexts = new HashMap<String, CommitContext>();
    private final boolean recovery;
    private IndexDefineCommand definitions;

    public LuceneCommandApplier(LuceneDataSource dataSource, boolean recovery) {
        this.dataSource = dataSource;
        this.recovery = recovery;
    }

    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) {
        EntityId.IdData entityId = new EntityId.IdData(command.getEntityId());
        return this.visitIndexAddCommand((IndexCommand)command, entityId);
    }

    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) {
        EntityId.RelationshipData entityId = new EntityId.RelationshipData(command.getEntityId(), command.getStartNode(), command.getEndNode());
        return this.visitIndexAddCommand((IndexCommand)command, entityId);
    }

    private boolean visitIndexAddCommand(IndexCommand command, EntityId entityId) {
        try {
            CommitContext context = this.commitContext(command);
            String key = this.definitions.getKey(command.getKeyId());
            Object value = command.getValue();
            if (value != null) {
                context.ensureWriterInstantiated();
                context.indexType.addToDocument(context.getDocument((EntityId)entityId, (boolean)true).document, key, value);
            }
        }
        catch (ExplicitIndexNotFoundKernelException explicitIndexNotFoundKernelException) {
            // empty catch block
        }
        return false;
    }

    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) {
        try {
            CommitContext context = this.commitContext((IndexCommand)command);
            String key = this.definitions.getKey(command.getKeyId());
            Object value = command.getValue();
            context.ensureWriterInstantiated();
            CommitContext.DocumentContext document = context.getDocument(new EntityId.IdData(command.getEntityId()), false);
            if (document != null) {
                context.indexType.removeFromDocument(document.document, key, value);
            }
        }
        catch (ExplicitIndexNotFoundKernelException explicitIndexNotFoundKernelException) {
            // empty catch block
        }
        return false;
    }

    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        try {
            CommitContext context = this.commitContext((IndexCommand)command);
            context.documents.clear();
            context.dataSource.deleteIndex(context.identifier, context.recovery);
        }
        catch (ExplicitIndexNotFoundKernelException explicitIndexNotFoundKernelException) {
            // empty catch block
        }
        return false;
    }

    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand createCommand) {
        return false;
    }

    public boolean visitIndexDefineCommand(IndexDefineCommand indexDefineCommand) {
        this.definitions = indexDefineCommand;
        return false;
    }

    public void close() {
        try {
            if (this.definitions != null) {
                this.dataSource.getWriteLock();
                for (CommitContext context : this.nodeContexts.values()) {
                    context.close();
                }
                for (CommitContext context : this.relationshipContexts.values()) {
                    context.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failure to commit changes to lucene", e);
        }
        finally {
            if (this.definitions != null) {
                this.dataSource.releaseWriteLock();
            }
        }
    }

    private CommitContext commitContext(IndexCommand command) throws ExplicitIndexNotFoundKernelException {
        String indexName;
        Map<String, CommitContext> contextMap = this.commitContextMap(command.getEntityType());
        CommitContext context = contextMap.get(indexName = this.definitions.getIndexName(command.getIndexNameId()));
        if (context == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.byId((byte)command.getEntityType()), indexName);
            IndexType type = this.dataSource.getType(identifier, this.recovery);
            context = new CommitContext(this.dataSource, identifier, type, this.recovery);
            contextMap.put(indexName, context);
        }
        return context;
    }

    private Map<String, CommitContext> commitContextMap(byte entityType) {
        if (entityType == IndexEntityType.Node.id()) {
            return this.nodeContexts;
        }
        if (entityType == IndexEntityType.Relationship.id()) {
            return this.relationshipContexts;
        }
        throw new IllegalArgumentException("Unknown entity type " + entityType);
    }
}

