/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.builder;

import java.io.File;
import java.util.Objects;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;

public class LuceneIndexStorageBuilder {
    private DirectoryFactory directoryFactory = DirectoryFactory.PERSISTENT;
    private FileSystemAbstraction fileSystem;
    private File indexRootFolder;
    private PartitionedIndexStorage indexStorage;

    private LuceneIndexStorageBuilder() {
    }

    public static LuceneIndexStorageBuilder create() {
        return new LuceneIndexStorageBuilder();
    }

    public PartitionedIndexStorage build() {
        if (this.indexStorage == null) {
            Objects.requireNonNull(this.directoryFactory);
            Objects.requireNonNull(this.fileSystem);
            Objects.requireNonNull(this.indexRootFolder);
            this.indexStorage = new PartitionedIndexStorage(this.directoryFactory, this.fileSystem, this.indexRootFolder);
        }
        return this.indexStorage;
    }

    public LuceneIndexStorageBuilder withDirectoryFactory(DirectoryFactory directoryFactory) {
        this.directoryFactory = directoryFactory;
        return this;
    }

    public LuceneIndexStorageBuilder withFileSystem(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public LuceneIndexStorageBuilder withIndexFolder(File indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
        return this;
    }

    public LuceneIndexStorageBuilder withIndexStorage(PartitionedIndexStorage indexStorage) {
        this.indexStorage = indexStorage;
        return this;
    }
}

