/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.TaskControl;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.AbstractIndexReader;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

public class SimpleIndexReader
extends AbstractIndexReader {
    private final PartitionSearcher partitionSearcher;
    private final SchemaIndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator;

    public SimpleIndexReader(PartitionSearcher partitionSearcher, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        super(descriptor);
        this.partitionSearcher = partitionSearcher;
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        TaskControl taskControl = this.taskCoordinator.newInstance();
        if (this.descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE) {
            return new UniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl);
        }
        return new NonUniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl, this.samplingConfig);
    }

    public void query(IndexProgressor.NodeValueClient client, IndexOrder indexOrder, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        Query query = this.toLuceneQuery(predicates);
        client.initialize(this.descriptor, this.search(query).getIndexProgressor("id", client), predicates);
    }

    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        Query query = this.toLuceneQuery(predicates);
        return this.search(query).getValuesIterator("id");
    }

    private DocValuesCollector search(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query toLuceneQuery(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exact: {
                Value[] values = new Value[predicates.length];
                for (int i = 0; i < predicates.length; ++i) {
                    assert (predicates[i].type() == IndexQuery.IndexQueryType.exact) : "Exact followed by another query predicate type is not supported at this moment.";
                    values[i] = ((IndexQuery.ExactPredicate)predicates[i]).value();
                }
                return LuceneDocumentStructure.newSeekQuery(values);
            }
            case exists: {
                for (IndexQuery p : predicates) {
                    if (p.type() == IndexQuery.IndexQueryType.exists) continue;
                    throw new IndexNotApplicableKernelException("Exists followed by another query predicate type is not supported.");
                }
                return LuceneDocumentStructure.newScanQuery();
            }
            case range: {
                this.assertNotComposite(predicates);
                switch (predicate.valueGroup()) {
                    case NUMBER: {
                        IndexQuery.NumberRangePredicate np = (IndexQuery.NumberRangePredicate)predicate;
                        return LuceneDocumentStructure.newInclusiveNumericRangeSeekQuery(np.from(), np.to());
                    }
                    case TEXT: {
                        IndexQuery.TextRangePredicate sp = (IndexQuery.TextRangePredicate)predicate;
                        return LuceneDocumentStructure.newRangeSeekByStringQuery(sp.from(), sp.fromInclusive(), sp.to(), sp.toInclusive());
                    }
                }
                throw new UnsupportedOperationException(String.format("Range scans of value group %s are not supported", predicate.valueGroup()));
            }
            case stringPrefix: {
                this.assertNotComposite(predicates);
                IndexQuery.StringPrefixPredicate spp = (IndexQuery.StringPrefixPredicate)predicate;
                return LuceneDocumentStructure.newRangeSeekByPrefixQuery(spp.prefix());
            }
            case stringContains: {
                this.assertNotComposite(predicates);
                IndexQuery.StringContainsPredicate scp = (IndexQuery.StringContainsPredicate)predicate;
                return LuceneDocumentStructure.newWildCardStringQuery(scp.contains());
            }
            case stringSuffix: {
                this.assertNotComposite(predicates);
                IndexQuery.StringSuffixPredicate ssp = (IndexQuery.StringSuffixPredicate)predicate;
                return LuceneDocumentStructure.newSuffixStringQuery(ssp.suffix());
            }
        }
        throw new RuntimeException("Index query not supported: " + Arrays.toString(predicates));
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    private void assertNotComposite(IndexQuery[] predicates) {
        assert (predicates.length == 1) : "composite indexes not yet supported for this operation";
    }

    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        TermQuery nodeIdQuery = new TermQuery(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
        Query valueQuery = LuceneDocumentStructure.newSeekQuery(propertyValues);
        BooleanQuery.Builder nodeIdAndValueQuery = new BooleanQuery.Builder().setDisableCoord(true);
        nodeIdAndValueQuery.add((Query)nodeIdQuery, BooleanClause.Occur.MUST);
        nodeIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)nodeIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.partitionSearcher.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.partitionSearcher.getIndexSearcher();
    }
}

